#include "Security.moc"
#include "AddNoRet.h"
#include <kapplication.h>
#include <klocale.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qwhatsthis.h>
#include <qbuttongroup.h>
#include <qspinbox.h>

Security::Security(QWidget * parent, const char *name)
 : SecurityBase(parent, name)
{
  ftpxs = 0;
  QWhatsThis::add(lbl1, i18n("Noretrieves are files and directories that can't be retrieved (downloaded) by remote users. Use the <b>Add</b> and <b>Remove</b> buttons below to control noretrieves."));
  QWhatsThis::add(noretrieves, i18n("Noretrieves are files and directories that can't be retrieved (downloaded) by remote users. Use the <b>Add</b> and <b>Remove</b> buttons below to control noretrieves."));
  connect(addNoRet, SIGNAL(clicked()), SLOT(addNoRetPressed()));
  connect(delNoRet, SIGNAL(clicked()), SLOT(delNoRetPressed()));
  QWhatsThis::add(addNoRet, i18n("Noretrieves are files and directories that can't be retrieved (downloaded) by remote users. Use the <b>Add</b> and <b>Remove</b> buttons below to control noretrieves."));
  QWhatsThis::add(delNoRet, i18n("Noretrieves are files and directories that can't be retrieved (downloaded) by remote users. Use the <b>Add</b> and <b>Remove</b> buttons below to control noretrieves."));
  QWhatsThis::add(lbl2, i18n("A user may attempt to login with a wrong password this many times before the connection is closed."));
  QWhatsThis::add(loginfails, i18n("A user may attempt to login with a wrong password this many times before the connection is closed."));
  QWhatsThis::add(priv, i18n("Permit users to change their group membership using the ftp SITE GROUP command"));
  QWhatsThis::add(PasswdNone, i18n("Don't check password given for anonymous/ftp at all"));
  QWhatsThis::add(PasswdTrivial, i18n("Password for anonymous/ftp must contain an @ character"));
  QWhatsThis::add(PasswdRFC, i18n("Make sure password for anonymous/ftp is a valid email address\naccording to RFC822"));
  QWhatsThis::add(PasswdEnforce, i18n("If this is checked, people using something other than an email address\nas anonymous password will not be allowed to log in.\n\nIf this is not checked, they will just be warned and told to use their\nemail address as password next time."));
}
Security::~Security()
{
}
void Security::ftpaccessLoaded(ftpaccess * xs)
{
  ftpxs = xs;
  loginfails->setValue(ftpxs->getLoginFails());
  priv->setChecked(ftpxs->getPrivate());
  chmodAnon->setChecked(ftpxs->getChmod() & ANONYMOUS);
  chmodGuest->setChecked(ftpxs->getChmod() & GUEST);
  chmodReal->setChecked(ftpxs->getChmod() & REAL);
  deleteAnon->setChecked(ftpxs->getDelete() & ANONYMOUS);
  deleteGuest->setChecked(ftpxs->getDelete() & GUEST);
  deleteReal->setChecked(ftpxs->getDelete() & REAL);
  overwriteAnon->setChecked(ftpxs->getOverwrite() & ANONYMOUS);
  overwriteGuest->setChecked(ftpxs->getOverwrite() & GUEST);
  overwriteReal->setChecked(ftpxs->getOverwrite() & REAL);
  renameAnon->setChecked(ftpxs->getRename() & ANONYMOUS);
  renameGuest->setChecked(ftpxs->getRename() & GUEST);
  renameReal->setChecked(ftpxs->getRename() & REAL);
  umaskAnon->setChecked(ftpxs->getUmask() & ANONYMOUS);
  umaskGuest->setChecked(ftpxs->getUmask() & GUEST);
  umaskReal->setChecked(ftpxs->getUmask() & REAL);
  if(ftpxs->getPwCheck() & TRIVIAL)
    PasswdTrivial->setChecked(true);
  else if(ftpxs->getPwCheck() & RFC822)
    PasswdRFC->setChecked(true);
  else
    PasswdNone->setChecked(true);
  PasswdEnforce->setChecked((ftpxs->getPwCheck() &((int) ENFORCE)) != 0);
  redrawNoRetrieves();
}
void Security::update()
{
  ftpxs->setLoginFails(loginfails->value());
  ftpxs->setPrivate(priv->isChecked());
  unsigned short tmp = 0;
  if (chmodAnon->isChecked())
    tmp |= ANONYMOUS;
  if (chmodGuest->isChecked())
    tmp |= GUEST;
  if (chmodReal->isChecked())
    tmp |= REAL;
  ftpxs->setChmod(tmp);
  tmp = 0;
  if (deleteAnon->isChecked())
    tmp |= ANONYMOUS;
  if (deleteGuest->isChecked())
    tmp |= GUEST;
  if (deleteReal->isChecked())
    tmp |= REAL;
  ftpxs->setDelete(tmp);
  tmp = 0;
  if (overwriteAnon->isChecked())
    tmp |= ANONYMOUS;
  if (overwriteGuest->isChecked())
    tmp |= GUEST;
  if (overwriteReal->isChecked())
    tmp |= REAL;
  ftpxs->setOverwrite(tmp);
  tmp = 0;
  if (renameAnon->isChecked())
    tmp |= ANONYMOUS;
  if (renameGuest->isChecked())
    tmp |= GUEST;
  if (renameReal->isChecked())
    tmp |= REAL;
  ftpxs->setRename(tmp);
  tmp = 0;
  if (umaskAnon->isChecked())
    tmp |= ANONYMOUS;
  if (umaskGuest->isChecked())
    tmp |= GUEST;
  if (umaskReal->isChecked())
    tmp |= REAL;
  ftpxs->setUmask(tmp);
  unsigned short pwVal = 0;
  if (PasswdNone->isChecked())
    pwVal |= NONE;
  else if (PasswdTrivial->isChecked())
    pwVal |= TRIVIAL;
  else
    pwVal |= RFC822;
  if (PasswdEnforce->isChecked())
    pwVal |= ENFORCE;
  ftpxs->setPwCheck(pwVal);
}
void Security::redrawNoRetrieves()
{
  noretrieves->clear();
  QStringList *l = ftpxs->getNoRetrieves();
  noretrieves->insertStringList(*l);
  noretrieves->update();
}
void Security::addNoRetPressed()
{
  AddNoRet anr;
  connect (&anr, SIGNAL(noRetAdded(const QString &)), SLOT(noRetAdded(const QString &)));
  anr.exec();
}
void Security::delNoRetPressed()
{
  QStringList * list = ftpxs->getNoRetrieves();
  for (unsigned int i=0; i<noretrieves->count(); i++)
    if (noretrieves->isSelected(i))
      list->remove(list->at(i));
  redrawNoRetrieves();
}
void Security::noRetAdded(const QString & filename)
{
  ftpxs->getNoRetrieves()->append(filename);
  redrawNoRetrieves();
}
