/***************************************************************************
                            kde_HTMLCollection.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLCOLLECTION
#define KDE_HTMLCOLLECTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 An <code> HTMLCollection </code> is a list of nodes. An individual
 node may be accessed by either ordinal index or the node's <code>
 name </code> or <code> id </code> attributes. Note: Collections in
 the HTML DOM are assumed to be live meaning that they are
 automatically updated when the underlying document is changed.

 
 @short *
 An <code> HTMLCollection </code> is a list of nodes.
*/
kde_HTMLCollection * kde_new_HTMLCollection();
kde_HTMLCollection * kde_new_HTMLCollection1(kde_HTMLCollection* other);
void kde_del_HTMLCollection( kde_HTMLCollection* p );

/** *
 This attribute specifies the length or size of the list.

     
*/
unsigned long kde_HTMLCollection_length(kde_HTMLCollection* instPointer);

/** *
 This method retrieves a node specified by ordinal index. Nodes
 are numbered in tree order (depth-first traversal order).

     
*/
kde_DOMNode* kde_HTMLCollection_item(kde_HTMLCollection* instPointer,unsigned long index);

/** *
 This method retrieves a <code> Node </code> using a name. It
 first searches for a <code> Node </code> with a matching <code>
 id </code> attribute. If it doesn't find one, it then searches
 for a <code> Node </code> with a matching <code> name </code>
 attribute, but only on those elements that are allowed a name
 attribute.

     
*/
kde_DOMNode* kde_HTMLCollection_namedItem(kde_HTMLCollection* instPointer,kde_DOMString* name);

/** *

 not part of the DOM
     
*/
kde_DOMNode* kde_HTMLCollection_base(kde_HTMLCollection* instPointer);
//kde_HTMLCollectionImpl* kde_HTMLCollection_handle(kde_HTMLCollection* instPointer);
int kde_HTMLCollection_isNull(kde_HTMLCollection* instPointer);
kde_DOMNode* kde_HTMLCollection_firstItem(kde_HTMLCollection* instPointer);
kde_DOMNode* kde_HTMLCollection_nextItem(kde_HTMLCollection* instPointer);
kde_DOMNode* kde_HTMLCollection_nextNamedItem(kde_HTMLCollection* instPointer,kde_DOMString* name);

#endif
