/***************************************************************************
                            kde_KDirNotify.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDIRNOTIFY
#define KDE_KDIRNOTIFY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 An abstract class that receives notifications of added and removed files
 in any directory, local or remote.
 The information comes from the konqueror/kdesktop instance where the
 operation was done, and can interest KDirListers, bookmark handlers, etc.
 
 @short *
 An abstract class that receives notifications of added and removed files
 in any directory, local or remote.
*/
//k_dcop: /** * Notify that files have been added in @p directory * Note: this is ASYNC so that it can be used with a broadcast */  ASYNC kde_KDirNotify_FilesAdded(kde_KDirNotify* instPointer,kde_KURL* directory);

/** *
 Notify that files have been deleted.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
void kde_KDirNotify_FilesRemoved(kde_KDirNotify* instPointer,kde_KURLList* fileList);

/** *
 Notify that files have been changed.
 At the moment, this is only used for new icon, but it could be
 used for size etc. as well.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
void kde_KDirNotify_FilesChanged(kde_KDirNotify* instPointer,kde_KURLList* fileList);

/** *
 Notify that a file has been renamed.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
void kde_KDirNotify_FileRenamed(kde_KDirNotify* instPointer,kde_KURL* src, kde_KURL* dst);

#endif
