/***************************************************************************
                            kde_KPixmapIO.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPIXMAPIO
#define KDE_KPIXMAPIO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 KPixmapIO implements a fast path for QPixmap to/from QImage conversions.
 It uses the MIT-SHM shared memory extension for this. If this extension is
 not available, it will fall back to standard Qt methods.

 You can use KPixmapIO for load/saving pixmaps.

 <pre>
 KPixmapIO io;
 pixmap = io.convertToPixmap(image);
 image = io.convertToImage(pixmap);
 </pre>

 It also has functionality for partially updating/saving pixmaps, see
 @ref #putImage and @ref #getImage.

 Speed measurements were taken. These show that usage of KPixmapIO for
 images up to a certain threshold size, offers no speed advantage over
 the Qt routines. Below you can see a plot of these measurements.

 The threshold size, amongst other causes, is determined by the shared
 memory allocation policy. If the policy is @p ShmDontKeep, the
 shared memory segment is discarded right after usage, and thus needs to
 be allocated before each transfer. This introduces a a setup penalty not
 present when the policy is @p ShmKeepAndGrow. In this case the
 shared memory segment is kept and resized when necessary, until the
 KPixmapIO object is destroyed.

 The default policy is @p ShmDontKeep. This policy makes sense when
 loading pixmaps once. The corresponding threshold is taken at 5.000
 pixels as suggested by experiments. Below this threshold, KPixmapIO
 will not use shared memory and fall back on the Qt routines.

 When the policy is @p ShmKeepAndGrow, the threshold is taken at
 2.000 pixels. Using this policy, you might want to use @ref #preAllocShm
 to pre-allocate a certain amount of shared memory, in order to avoid
 resizes. This allocation policy makes sense in a multimedia type
 application where you are constantly updating the screen.

 Above a couple times the threshold size, KPixmapIO's and Qt's speed become
 linear in the number of pixels, KPixmapIO being at least 2, and mostly around
 4 times faster than Qt, depending on the screen and image depth.

 Speed difference seems to be the most at 16 bpp, followed by 32 and 24
 bpp respectively. This can be explained by the relatively poor
 implementation of 16 bit RGB packing in Qt, while at 32 bpp we need to
 transfer more data, and thus gain more, than at 24 bpp.

 For large pixmaps, there's a definite speed improvement when using
 KPixmapIO. On the other hand, there's no speed improvement for small
 pixmaps. When you know you're only transferring small pixmaps, there's no
 point in using it.
 
 @author Geert Jansen <jansen@kde.org>

 @version $Id: kde_KPixmapIO.h,v 1.4 2002/11/25 12:24:34 rdale Exp $

 @short Fast QImage to/from QPixmap conversion.

*/
#define KPIXMAPIO_ShmDontKeep	0
#define KPIXMAPIO_ShmKeepAndGrow	1
kde_KPixmapIO * kde_new_KPixmapIO();
void kde_del_KPixmapIO( kde_KPixmapIO* p );

/** *
 Convert an image to a pixmap.

*/
qt_QPixmap * kde_KPixmapIO_convertToPixmap(kde_KPixmapIO* instPointer,qt_QImage * image);

/** *
 Convert a pixmap to an image.

*/
qt_QImage * kde_KPixmapIO_convertToImage(kde_KPixmapIO* instPointer,qt_QPixmap * pixmap);

/** *
 Bitblt an image onto a pixmap.

*/
void kde_KPixmapIO_putImage(kde_KPixmapIO* instPointer,qt_QPixmap * dst, int dx, int dy, qt_QImage* src);

/** *
 This function is identical to the one above. It only differs in the
 arguments it accepts.
     
*/
void kde_KPixmapIO_putImage1(kde_KPixmapIO* instPointer,qt_QPixmap * dst, qt_QPoint* offset, qt_QImage* src);

/** *
 Transfer (a part of) a pixmap to an image.

*/
qt_QImage * kde_KPixmapIO_getImage(kde_KPixmapIO* instPointer,qt_QPixmap * src, int sx, int sy, int sw, int sh);

/** *
 This function is identical to the one above. It only differs in the
 arguments it accepts.
     
*/
qt_QImage * kde_KPixmapIO_getImage1(kde_KPixmapIO* instPointer,qt_QPixmap * src, qt_QRect* rect);

/** *
 Set the shared memory allocation policy. See the introduction for
 KPixmapIO for a discussion.

*/
void kde_KPixmapIO_setShmPolicy(kde_KPixmapIO* instPointer,int policy);

/** *
 Pre-allocate shared memory. KPixmapIO will be able to transfer images
 up to this size without resizing.

*/
void kde_KPixmapIO_preAllocShm(kde_KPixmapIO* instPointer,int size);

#endif
