/***************************************************************************
                            KDateTable.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDATETABLE_H
#define KDATETABLE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QGridView.h>

/**

 Date selection table.
 This is a support class for the KDatePicker class.  It just
 draws the calender table without titles, but could theoretically
 be used as a standalone.

 When a date is selected by the user, it emits a signal:
 dateSelected(QDate)

 @author Tim Gilman, Mirko Boehm
 
 @version $Id: KDateTable.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short 
 Date selection table.
*/
@interface KDateTable : QGridView 

/**  The constructor. 
*/
- initWithWidget: (QWidget *)parent date: (NSDate *)date name: (NSString *)name f: (int)f;
- init;

/**  Returns a recommended size for the widget.
	To save some time, the size of the largest used cell content is
	calculated in each -paintCell call, since all calculations have
	to be done there anyway. The size is stored in maxCell. The
	-sizeHint simply returns a multiple of maxCell. 
*/
- (QSize*) sizeHint;

/**  Set the font size of the date table. 
*/
- setFontSize: (int)size;

/**  Select and display this date. 
*/
- (BOOL) setDate: (NSDate *)arg1;
- (NSDate *) getDate;

/**  Paint a cell. 
*/
- paintCell: (QPainter *)arg1 int: (int)arg2 int: (int)arg3;
@end

/** Override these methods in subclasses of KDateTable to customise event handling behaviour */
@protocol KDateTableEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) e;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) arg1;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;

/**  React on mouse clicks that select a date. 
*/
- contentsMousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/**  Handle the resize events. 
*/
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
