/***************************************************************************
                            KGradientSelector.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRADIENTSELECTOR_H
#define KGRADIENTSELECTOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KSelector.h>

/**

 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
 
 @short 
 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
*/
@interface KGradientSelector : KSelector 

/** 
 Constructs a horizontal color selector which
 contains a gradient between white and black.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a colors selector with orientation o which
 contains a gradient between white and black.
   
*/
- initWithInt: (int)o parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)o ;

/** 
 Destructs the widget.
   
*/
- (void) dealloc;

/** 
 Sets the two colors which span the gradient.
   
*/
- setColors: (QColor *)col1 col2: (QColor *)col2;
- setText: (NSString *)t1 t2: (NSString *)t2;

/** 
 Set each color on its own.
   
*/
- setFirstColor: (QColor *)col;
- setSecondColor: (QColor *)col;

/** 
 Set each description on its own
   
*/
- setFirstText: (NSString *)t;
- setSecondText: (NSString *)t;
- (QColor*) firstColor;
- (QColor*) secondColor;
- (NSString *) firstText;
- (NSString *) secondText;
@end

/** Override these methods in subclasses of KGradientSelector to customise event handling behaviour */
@protocol KGradientSelectorEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 

   
*/
- mousePressEvent:(QMouseEvent*) e;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;

/** 

   
*/
- mouseMoveEvent:(QMouseEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 

   
*/
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
