/***************************************************************************
                           quizwidget.h  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#ifndef QUIZWIDGET_H
#define QUIZWIDGET_H

#include <kprogress.h>
#include <kstatusbar.h>
#include <klineedit.h>

#include <qwidget.h>
#include <qlayout.h>

#include "card.h"

class QuizWidget : public QWidget
{
  Q_OBJECT

public: 

  QuizWidget(KStatusBar *statusBar, QWidget *parent, const char *name = 0);
  virtual ~QuizWidget();

  void setCardList(const CardList &list);
  bool frontBackReversed() const;

  /**
   * These functions should rather obviously be implemented in subclasses where
   * useful.  I am providing empty default implementations for subclasses which
   * do not nead copy and paste functionality.
   */
  virtual void cut() {};
  virtual void copy() {};
  virtual bool hasSelectedText() { return false; }

public slots:
  Card getCard(bool random = true);
  void setFrontBackReversed(bool reverse);
  void setShowAnswerLength(int length);

protected:
  void setFeedbackMessage(const QString &message);
  void showFeedbackLabel(bool show = true);
  QBoxLayout *layout();
  virtual bool eventFilter(QObject *object, QEvent *event);
  int numberOfCards() const;
  int showAnswerLength() const { return showAnswer; }

private:
  void setupLayout();
  virtual void showCard(const Card &card) = 0;
  virtual QString completeMessage();

  KStatusBar *mainStatusBar;
  QVBoxLayout *mainLayout;
  QLabel *feedbackLabel;
  KProgress *progressBar;
  
  CardList completeCardList;
  CardList remainingCardList;

  Card currentCard;
  bool reversed;
  int showAnswer;
  
signals:
  void selectionChanged(); 
  void lineEditFocusIn(KLineEdit *);
  void lineEditFocusOut();
};

#endif
