#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <kcombobox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include "NewWindowDialog.h"

NewWindowDialog::NewWindowDialog(QWidget * parent, const char * name)
  : KDialogBase(parent, name, true, i18n("New Window For"), Ok|Cancel, Ok, true)
{
  QHBox * w = makeHBoxMainWidget();

  QLabel * l = new QLabel(i18n("C&hannel/Nick:"), w);

  combo_ = new KHistoryCombo(w);
  combo_->setFocus();

  l->setBuddy(combo_);

  connect(
      combo_, SIGNAL(activated(const QString &)),
      combo_, SLOT(addToHistory(const QString &)));
  connect( combo_->lineEdit(), SIGNAL(textChanged ( const QString & )),
	   this, SLOT( slotTextChanged( const QString &)));

  KConfig *kConfig = kapp->config();
  KConfigGroupSaver saver(kConfig, "Recent");
  combo_->setHistoryItems(kConfig->readListEntry("Channels"));
  slotTextChanged( combo_->lineEdit()->text());
}

NewWindowDialog::~NewWindowDialog()
{
  KConfig *kConfig = kapp->config();
  KConfigGroupSaver saver(kConfig, "Recent");
  kConfig->writeEntry("Channels", combo_->historyItems());
}

void NewWindowDialog::slotTextChanged( const QString &_text)
{
  enableButtonOK( !_text.isEmpty() );
}


  void
NewWindowDialog::slotOk()
{
  emit(openTopLevel(combo_->currentText()));
  KDialogBase::slotOk();
}

#include "NewWindowDialog.moc"

