/* This file is part of the KDE project
   Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "kshellcmdplugin.h"
#include <klineeditdlg.h>
#include <kmessagebox.h>
#include <konq_dirpart.h>
#include <kprocess.h>
#include <kapplication.h>
#include "kshellcmddialog.h"
#include <kgenericfactory.h>

KShellCmdPlugin::KShellCmdPlugin( QObject* parent, const char* name,
	                          const QStringList & )
    : KParts::Plugin( parent, name )
{
    if (!kapp->authorize("shell_access"))
       return;

    new KAction( i18n( "&Execute Shell Command..." ), CTRL+Key_E, this,
                 SLOT( slotExecuteShellCommand() ), actionCollection(), "executeshellcommand" );
}

void KShellCmdPlugin::slotExecuteShellCommand()
{
   KonqDirPart * part = dynamic_cast<KonqDirPart *>(parent());
   if ( !part )
   {
      KMessageBox::sorry(0L, "KShellCmdPlugin::slotExecuteShellCommand: Program error, please report a bug.");
      return;
   }
   KURL url = part->url();
   if ( !url.isLocalFile() )
   {
      KMessageBox::sorry(part->widget(),i18n("Executing shell commands works only on local directories."));
      return;
   }
   QString defaultValue;
   if ( part->currentItem() )
   {
     // Putting the complete path to the selected file isn't really necessary, since
     // we'll cd to the directory first. But we do need to get the complete relative path.
     QString path = part->currentItem()->url().path();
     defaultValue = KProcess::quote( "." + path.remove( 0, url.path().length() ) );
   }
   else
   {
      defaultValue = KProcess::quote( url.path() );
   }
   KLineEditDlg l(i18n("Execute shell command in current directory:"), defaultValue, part->widget() );
   if ( l.exec() )
   {
      QString chDir;
      chDir="cd ";
      chDir+=KProcess::quote(part->url().path());
      chDir+="; ";
      chDir+=l.text();

      KShellCommandDialog *shellCmdDialog=new KShellCommandDialog(i18n("Output from command: \"%1\"").arg(l.text()),chDir,part->widget(),true);
      shellCmdDialog->resize(500,300);
      shellCmdDialog->executeCommand();
      delete shellCmdDialog;
   }
}

K_EXPORT_COMPONENT_FACTORY( konq_shellcmdplugin, KGenericFactory<KShellCmdPlugin> );

#include "kshellcmdplugin.moc"

