//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMNORMAL_H
#define PMNORMAL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"

/**
 * Class for povray normals
 */
class PMNormal : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates an PMNormal */
   PMNormal( );
   /** Deletes the object */
   virtual ~PMNormal( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMNormal( ); }
   /** */
   virtual QString className( ) const { return QString( "normal" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTNormal; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const;
   /** */
   virtual int canInsert( const PMObjectList& list,
                          const PMObject* after ) const;
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   
   /** Returns a new @ref PMNormalEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmnormal" ); }

   /** */
   virtual void restoreMemento( PMMemento* s );

   /** Returns true if bump_size is enabled */
   bool isBumpSizeEnabled( ) const { return m_enableBumpSize; }
   /** enables/disables bump_size */
   void enableBumpSize( bool c );
   /** Returns the normal's bump size */
   double bumpSize( ) const { return m_bumpSize; }
   /** Sets the normal's bump size */
   void setBumpSize( double c );

private:
   void countChild( PMObjectType t, PMObject* o,
                    int& bumpMap, int& listpattern, int& pattern, int& normalMap, 
                    int& slopeMap, int& warp, int &blend, bool& afterPattern, 
                    bool& afterNormalMap, bool& afterSlopeMap, bool& afterWarp, 
                    bool& hasDepth, bool& afterBlend, bool& afterTransform, 
                    bool insertPoint ) const;
   bool canInsert( PMObjectType t,
                   int bumpMap, int listpattern, int pattern, int normalMap, 
                   int slopeMap, int warp, int blend, bool afterPattern, 
                   bool afterNormalMap, bool afterSlopeMap, bool afterWarp, 
                   bool hasDepth, bool afterBlend, bool afterTransform ) const;

   /** IDs for @ref PMMementoData */
   enum PMNormalMementoID { PMEnableBumpSizeID, PMBumpSizeID };

   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;

   bool m_enableBumpSize;
   double m_bumpSize;
};


#endif
