/* 
 * memo/Record.java:
 *
 * Copyright (C) 1997, 1998, Kenneth Albanowski
 * Copyright (C) 2001 David.Goodenough@DGA.co.uk 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package org.gnu.pdapilot.memo;

import java.io.*;
import org.gnu.pdapilot.Util;

/** A representation of a memo database record.
 */

public class Record extends org.gnu.pdapilot.Record {
   private String text;
   public Record( ) { super( ); }
   public Record( byte[ ]contents, org.gnu.pdapilot.RecordID id, int index, int attr, int cat) {
      super( contents, id, index, attr, cat); 
      }
   public native void unpack( byte[ ]data);
   public native byte[ ]pack( );
   public void fill( ) { text = ""; }
   public String describe( ) {
     return "text '" + Util.prettyPrint( text) + "', " + super.describe( );
     }
   // Accessor Methods
   public void setText( String t) { text = t; }
   public String getText( ) { return text; }
   }
