/*
  'OpenLook' kwin client

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to
  deal in the Software without restriction, including without limitation the
  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
  sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:
 
  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef KWIN_WEB_H
#define KWIN_WEB_H

#include <qptrlist.h>

#include <kwin/client.h>

class QSpacerItem;

namespace OpenLook
{
  using namespace KWinInternal;
  
  class OpenLookButton;

  class OpenLook : public Client
  {
    Q_OBJECT

    public:

      OpenLook
        (
         Workspace *,
         WId,
         bool tool,
         QWidget * parent = 0,
         const char * name = 0
        );

      ~OpenLook();

    protected:

      virtual void captionChange(const QString &);
      virtual void paintEvent(QPaintEvent *);
      virtual void mouseDoubleClickEvent(QMouseEvent *);
      virtual void mousePressEvent(QMouseEvent *);
      virtual void mouseReleaseEvent(QMouseEvent *);

      virtual void activeChange(bool);
      virtual MousePosition mousePosition(const QPoint &) const;
      virtual void animateIconifyOrDeiconify(bool);

    protected slots:

      void slotReset();

    private:

      void doLayout();

      QRect titleRect() const;

      QRect topLeftRect() const;
      QRect topRightRect() const;
      QRect bottomLeftRect() const;
      QRect bottomRightRect() const;

      QRect buttonRect() const;

      void paintBorder(QPainter &) const;

      void paintTopLeftRect(QPainter &) const;
      void paintTopRightRect(QPainter &) const;
      void paintBottomLeftRect(QPainter &) const;
      void paintBottomRightRect(QPainter &) const;

      void paintButton(QPainter &) const;
      void paintArrow(QPainter &) const;

      bool            tool_;
      bool            buttonDown_;
      QSpacerItem   * titleSpacer_;
      QPoint          mousePressPoint_;
  };
}

#endif
// vim:ts=2:sw=2:tw=78:set et:
