/***************************************************************************
                            kde_CSSPrimitiveValue.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_CSSPRIMITIVEVALUE
#define KDE_CSSPRIMITIVEVALUE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The <code> CSSPrimitiveValue </code> interface represents a single
 <a href="http://www.w3.org/TR/REC-CSS2/syndata.html#values"> CSS
 value </a> . This interface may be used to determine the value of a
 specific style property currently set in a block or to set a
 specific style properties explicitly within the block. An instance
 of this interface can be obtained from the <code>
 getPropertyCSSValue </code> method of the <code>
 CSSStyleDeclaration </code> interface.

 
 @short *
 The <code> CSSPrimitiveValue </code> interface represents a single
 <a href="http://www.
*/
#define CSSPRIMITIVEVALUE_CSS_UNKNOWN	0
#define CSSPRIMITIVEVALUE_CSS_NUMBER	1
#define CSSPRIMITIVEVALUE_CSS_PERCENTAGE	2
#define CSSPRIMITIVEVALUE_CSS_EMS	3
#define CSSPRIMITIVEVALUE_CSS_EXS	4
#define CSSPRIMITIVEVALUE_CSS_PX	5
#define CSSPRIMITIVEVALUE_CSS_CM	6
#define CSSPRIMITIVEVALUE_CSS_MM	7
#define CSSPRIMITIVEVALUE_CSS_IN	8
#define CSSPRIMITIVEVALUE_CSS_PT	9
#define CSSPRIMITIVEVALUE_CSS_PC	10
#define CSSPRIMITIVEVALUE_CSS_DEG	11
#define CSSPRIMITIVEVALUE_CSS_RAD	12
#define CSSPRIMITIVEVALUE_CSS_GRAD	13
#define CSSPRIMITIVEVALUE_CSS_MS	14
#define CSSPRIMITIVEVALUE_CSS_S	15
#define CSSPRIMITIVEVALUE_CSS_HZ	16
#define CSSPRIMITIVEVALUE_CSS_KHZ	17
#define CSSPRIMITIVEVALUE_CSS_DIMENSION	18
#define CSSPRIMITIVEVALUE_CSS_STRING	19
#define CSSPRIMITIVEVALUE_CSS_URI	20
#define CSSPRIMITIVEVALUE_CSS_IDENT	21
#define CSSPRIMITIVEVALUE_CSS_ATTR	22
#define CSSPRIMITIVEVALUE_CSS_COUNTER	23
#define CSSPRIMITIVEVALUE_CSS_RECT	24
#define CSSPRIMITIVEVALUE_CSS_RGBCOLOR	25
#define CSSPRIMITIVEVALUE_CSS_HTML_RELATIVE	255
kde_CSSPrimitiveValue * kde_new_CSSPrimitiveValue();
kde_CSSPrimitiveValue * kde_new_CSSPrimitiveValue1(kde_CSSPrimitiveValue* other);
kde_CSSPrimitiveValue * kde_new_CSSPrimitiveValue2(kde_CSSValue* other);
void kde_del_CSSPrimitiveValue( kde_CSSPrimitiveValue* p );

/** *
 The type of the value as defined by the constants specified
 above.

     
*/
unsigned short kde_CSSPrimitiveValue_primitiveType(kde_CSSPrimitiveValue* instPointer);

/** *
 A method to set the float value with a specified unit. If the
 property attached with this value can not accept the specified
 unit or the float value, the value will be unchanged and a
 <code> DOMException </code> will be raised.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this property is
 readonly.

     
*/
void kde_CSSPrimitiveValue_setFloatValue(kde_CSSPrimitiveValue* instPointer,unsigned short unitType, float floatValue);

/** *
 This method is used to get a float value in a specified unit.
 If this CSS value doesn't contain a float value or can't be
 converted into the specified unit, a <code> DOMException
 </code> is raised.

     
*/
float kde_CSSPrimitiveValue_getFloatValue(kde_CSSPrimitiveValue* instPointer,unsigned short unitType);

/** *
 A method to set the string value with a specified unit. If the
 property attached to this value can't accept the specified unit
 or the string value, the value will be unchanged and a <code>
 DOMException </code> will be raised.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this property is
 readonly.

     
*/
void kde_CSSPrimitiveValue_setStringValue(kde_CSSPrimitiveValue* instPointer,unsigned short stringType, kde_DOMString* stringValue);

/** *
 This method is used to get the string value in a specified
 unit. If the CSS value doesn't contain a string value, a <code>
 DOMException </code> is raised.

     
*/
kde_DOMString* kde_CSSPrimitiveValue_getStringValue(kde_CSSPrimitiveValue* instPointer);

/** *
 This method is used to get the Counter value. If this CSS value
 doesn't contain a counter value, a <code> DOMException </code>
 is raised. Modification to the corresponding style property can
 be achieved using the <code> Counter </code> interface.

     
*/
kde_Counter* kde_CSSPrimitiveValue_getCounterValue(kde_CSSPrimitiveValue* instPointer);

/** *
 This method is used to get the Rect value. If this CSS value
 doesn't contain a rect value, a <code> DOMException </code> is
 raised. Modification to the corresponding style property can be
 achieved using the <code> Rect </code> interface.

     
*/
kde_Rect* kde_CSSPrimitiveValue_getRectValue(kde_CSSPrimitiveValue* instPointer);

/** *
 This method is used to get the RGB color. If this CSS value
 doesn't contain a RGB color value, a <code> DOMException
 </code> is raised. Modification to the corresponding style
 property can be achieved using the <code> RGBColor </code>
 interface.

     
*/
kde_RGBColor* kde_CSSPrimitiveValue_getRGBColorValue(kde_CSSPrimitiveValue* instPointer);

#endif
