/***************************************************************************
                            kde_KApplication.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KAPPLICATION
#define KDE_KAPPLICATION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Controls and provides information to all KDE applications.

 Only one object of this class can be instantiated in a single app.
 This instance is always accessible via the @ref kApplication() method.

 This class provides the following services to all KDE applications.

 The way a service gets started depends on the 'X-DCOP-ServiceType'
 entry in the desktop file of the service:

 There are three possibilities:

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: kde_KApplication.h,v 1.4 2002/11/25 12:24:32 rdale Exp $

 @short Controls and provides information to all KDE applications.

*/
#define KAPPLICATION_CaptionAppLast	1
#define KAPPLICATION_CaptionAppFirst	0
#define KAPPLICATION_CaptionNoApp	1
#define KAPPLICATION_/***Obeytheuser'sconfirmationsetting.*/ShutdownConfirmDefault	-1
#define KAPPLICATION_/***Don'tconfirm	0
#define KAPPLICATION_shutdownwithoutasking.*/ShutdownConfirmNo	0
#define KAPPLICATION_/***Alwaysconfirm	1
#define KAPPLICATION_askeveniftheuserturneditoff.*/ShutdownConfirmYes	1
#define KAPPLICATION_/***Selectpreviousactionorthedefaultifit'sthefirsttime.*/ShutdownTypeDefault	-1
#define KAPPLICATION_/***Onlylogout.*/ShutdownTypeNone	0
#define KAPPLICATION_/***Logoutandrebootthemachine.*/ShutdownTypeReboot	1
#define KAPPLICATION_/***Logoutandhaltthemachine.*/ShutdownTypeHalt	2
#define KAPPLICATION_/***Selectpreviousmodeorthedefaultifit'sthefirsttime.*/ShutdownModeDefault	-1
#define KAPPLICATION_/***Scheduleashutdown(haltorreboot)forthetimeallactivesessions*haveexited.*/ShutdownModeSchedule	0
#define KAPPLICATION_/***Shutdown	0
#define KAPPLICATION_ifnosessionsareactive.Otherwisedonothing.*/ShutdownModeTryNow	1
#define KAPPLICATION_/***Forceshutdown.Killanypossiblyactivesessions.*/ShutdownModeForceNow	2
#define KAPPLICATION_/***Popupadialogaskingtheuserwhattodoifsessionsarestillactive.*/ShutdownModeInteractive	3
#define KAPPLICATION_ShiftModifier	1<<0
#define KAPPLICATION_LockModifier	1<<1
#define KAPPLICATION_ControlModifier	1<<2
#define KAPPLICATION_Modifier1	1<<3
#define KAPPLICATION_Modifier2	1<<4
#define KAPPLICATION_Modifier3	1<<5
#define KAPPLICATION_Modifier4	1<<6
#define KAPPLICATION_Modifier5	1<<7
#define KAPPLICATION_Button1Pressed	1<<8
#define KAPPLICATION_Button2Pressed	1<<9
#define KAPPLICATION_Button3Pressed	1<<10
#define KAPPLICATION_Button4Pressed	1<<11
#define KAPPLICATION_Button5Pressed	1<<12
#define KAPPLICATION_SETTINGS_MOUSE	0
#define KAPPLICATION_SETTINGS_COMPLETION	1
#define KAPPLICATION_SETTINGS_PATHS	2
#define KAPPLICATION_SETTINGS_POPUPMENU	3
#define KAPPLICATION_SETTINGS_QT	4
#define KAPPLICATION_SETTINGS_SHORTCUTS	5

/** *
 This constructor takes aboutData and command line
  arguments from @ref KCmdLineArgs.

*/
kde_KApplication * kde_new_KApplication(int allowStyles, int GUIenabled);

/** *
 Constructor. Parses command-line arguments. Use this constructor to use KApplication
 in a Motif or Xt program.

*/
//kde_KApplication * kde_new_KApplication1(Display* display, int argc, char** argv, qt_QCString* rAppName, int allowStyles, int GUIenabled);

/** *

 // REMOVE FOR KDE 4.0 - using it only gives crashing applications because
 // KCmdLineArgs::init isn't called

 Constructor. Parses command-line arguments.

*/
kde_KApplication * kde_new_KApplication2(int argc, char** argv, qt_QCString* rAppName, int allowStyles, int GUIenabled);
void kde_del_KApplication( kde_KApplication* p );

/** *
 Returns the application session config object.

*/
kde_KConfig* kde_KApplication_sessionConfig(kde_KApplication* instPointer);

/** *
 Is the application restored from the session manager?

*/
int kde_KApplication_isRestored(kde_KApplication* instPointer);

/** *
 Disables session management for this application.

 Useful in case  your application is started by the
 initial "startkde" script.
   
*/
void kde_KApplication_disableSessionManagement(kde_KApplication* instPointer);

/** *
 Asks the session manager to shut the session down.

 Using @p confirm == ShutdownConfirmYes or @p sdtype != ShutdownTypeDefault or
 @p sdmode != ShutdownModeDefault causes the use of ksmserver's DCOP
 interface. The remaining two combinations use the standard XSMP and
 will work with any session manager compliant with it.

*/
int kde_KApplication_requestShutDown(kde_KApplication* instPointer,int confirm, int sdtype, int sdmode);

/** *
 Propagates the network address of the session manager in the
 SESSION_MANAGER environment variable so that child processes can
 pick it up.

 If SESSION_MANAGER isn't defined yet, the address is searched in
 $HOME/.KSMserver.

 This function is called by clients that are started outside the
 session ( i.e. before ksmserver is started), but want to launch
 other processes that should participate in the session.  Examples
 are kdesktop or kicker.
   
*/
void kde_KApplication_propagateSessionManager(kde_KApplication* instPointer);
void kde_KApplication_commitData(kde_KApplication* instPointer,qt_QSessionManager* sm);
void kde_KApplication_saveState(kde_KApplication* instPointer,qt_QSessionManager* sm);

/** *
 Returns a @ref QPixmap with the application icon.

*/
qt_QPixmap * kde_KApplication_icon(kde_KApplication* instPointer);

/** *
 Returns the name of the application icon.

*/
qt_QString * kde_KApplication_iconName(kde_KApplication* instPointer);

/** *
 Returns the mini-icon for the application as a @ref QPixmap.

*/
qt_QPixmap * kde_KApplication_miniIcon(kde_KApplication* instPointer);

/** *
 Returns the name of the mini-icon for the application.

*/
qt_QString * kde_KApplication_miniIconName(kde_KApplication* instPointer);

/** *
  Sets the top widget of the application.
  This means basically applying the right window caption and
  icon. An application may have several top widgets. You don't
  need to call this function manually when using @ref KMainWindow.

*/
void kde_KApplication_setTopWidget(kde_KApplication* instPointer,qt_QWidget * topWidget);

/** *
 Invokes the KHelpCenter HTML help viewer from docbook sources.

*/
void kde_KApplication_invokeHelp(kde_KApplication* instPointer,qt_QString * anchor, qt_QString * appname);

/** *

 Invoke the khelpcenter HTML help viewer from HTML sources.
 Please use invokeHelp() instead.

*/
void kde_KApplication_invokeHTMLHelp(kde_KApplication* instPointer,qt_QString * aFilename, qt_QString * aTopic);

/** *
 Convenience method; invokes the standard email application.

*/
void kde_KApplication_invokeMailer(kde_KApplication* instPointer,qt_QString * address, qt_QString * subject);

/** *
 Invokes the standard email application.

*/
void kde_KApplication_invokeMailer1(kde_KApplication* instPointer,kde_KURL* mailtoURL);

/** *
 Convenience method; invokes the standard email application.

 All parameters are optional.

*/
void kde_KApplication_invokeMailer2(kde_KApplication* instPointer,qt_QString * to, qt_QString * cc, qt_QString * bcc, qt_QString * subject, qt_QString * body, qt_QString * messageFile, qt_QStringList* attachURLs);

/** *
 Returns a text for the window caption.

 This may be set by
 "-caption", otherwise it will be equivalent to the name of the
 executable.

*/
qt_QString * kde_KApplication_caption(kde_KApplication* instPointer);

/** *

   
*/
//kde_KStyle* kde_KApplication_kstyle(kde_KApplication* instPointer);

/** *
 Builds a caption that contains the application name along with the
 @ref userCaption() using a standard layout.

 To make a compliant caption
 for your window, simply do: @p setCaption(kapp->makeStdCaption(yourCaption));

*/
qt_QString * kde_KApplication_makeStdCaption(kde_KApplication* instPointer,qt_QString * userCaption, int withAppName, int modified);

/** *
 Get a file name in order to make a temporary copy of your document.

*/
qt_QString * kde_KApplication_tempSaveName(kde_KApplication* instPointer,qt_QString * pFilename);

/** *
 Check whether  an auto-save file exists for the document you want to
 open.

*/
qt_QString * kde_KApplication_checkRecoverFile(kde_KApplication* instPointer,qt_QString * pFilename, int bRecover);

/** *
 Enables style plugins.

 This is useful only to applications that normally
 do not display a GUI and create the KApplication with
 allowStyles set to false.
   
*/
void kde_KApplication_enableStyles(kde_KApplication* instPointer);

/** *
 Disables style plugins.

 Current style plugins do not get unloaded.

 This is only useful when used in combination with @ref enableStyles().
   
*/
void kde_KApplication_disableStyles(kde_KApplication* instPointer);

/** *
  Installs widget filter as global X11 event filter.

 The widget
  filter receives XEvents in its standard @ref QWidget::x11Event() function.

  Warning: Only do this when absolutely necessary. An installed X11 filter
  can slow things down.

*/
void kde_KApplication_installX11EventFilter(kde_KApplication* instPointer,qt_QWidget * filter);

/** *
 Adds a message type to the KIPC event mask. You can only add "system
 messages" to the event mask. These are the messages with id < 32.
 Messages with id >= 32 are user messages.

*/
void kde_KApplication_addKipcEventMask(kde_KApplication* instPointer,int identifier);

/** *
 Removes a message type from the @ref KIPC event mask. This message will 
 not be handled anymore.

*/
void kde_KApplication_removeKipcEventMask(kde_KApplication* instPointer,int identifier);

/** *
 Returns the app startup notification identifier for this running 
 application.

*/
qt_QCString* kde_KApplication_startupId(kde_KApplication* instPointer);

/** *
 Sets a new value for the application startup notification window property for newly
 created toplevel windows.

*/
void kde_KApplication_setStartupId(kde_KApplication* instPointer,qt_QCString* startup_id);

/** *
 Returns the argument to --geometry if any, so the geometry can be set
 wherever necessary

*/
qt_QString * kde_KApplication_geometryArgument(kde_KApplication* instPointer);

/** *
 Install a Qt SQL property map with entries for all KDE widgets
 Call this in any application using KDE widgets in QSqlForm or QDataView.
   
*/
void kde_KApplication_installKDEPropertyMap(kde_KApplication* instPointer);

/** *
 Returns whether a certain action is authorized

*/
int kde_KApplication_authorize(kde_KApplication* instPointer,qt_QString * genericAction);

/** *
 Returns whether a certain KAction is authorized.

*/
int kde_KApplication_authorizeKAction(kde_KApplication* instPointer,char* action);

/** *
 Returns whether a certain URL related action is authorized.

*/
int kde_KApplication_authorizeURLAction(kde_KApplication* instPointer,qt_QString * action, kde_KURL* baseURL, kde_KURL* destURL);

/** *

   
*/
int kde_KApplication_notify(kde_KApplication* instPointer,qt_QObject * receiver, qt_QEvent * event);

/** *

    
*/
int kde_KApplication_xioErrhandler(kde_KApplication* instPointer);

/** *

   
*/
//void kde_KApplication_iceIOErrorHandler(kde_KApplication* instPointer,_IceConn* conn);

/** *
 Invokes the standard browser.
 Note that you should only do this when you know for sure that the browser can
 handle the URL (i.e. its mimetype). In doubt, if the URL can point to an image
 or anything else than directory or HTML, prefer to use new KRun( url ).

*/
void kde_KApplication_invokeBrowser(kde_KApplication* instPointer,qt_QString * url);

/** *
 Tells KApplication about one more operation that should be finished
 before the application exits. The standard behavior is to exit on the
 "last window closed" event, but some events should outlive the last window closed
 (e.g. a file copy for a file manager, or 'compacting folders on exit' for a mail client).
   
*/
void kde_KApplication_ref(kde_KApplication* instPointer);

/** *
 Tells KApplication that one operation such as those described in @ref just finished.
 The application exits if the counter is back to 0.
   
*/
void kde_KApplication_deref(kde_KApplication* instPointer);

/** *
 Add Qt and KDE command line options to KCmdLineArgs.
    
*/
void kde_KApplication_addCmdLineOptions( );

/** *
 Returns the current application object.

 This is similar to the global @ref QApplication pointer qApp. It
 allows access to the single global KApplication object, since
 more than one cannot be created in the same application. It
 saves you the trouble of having to pass the pointer explicitly
 to every function that may require it.

*/
kde_KApplication* kde_KApplication_kApplication( );

/** *
 Returns a pointer to a @ref DCOPClient for the application.
 If a client does not exist yet, it is created when this
 function is called.

*/
kde_DCOPClient* kde_KApplication_dcopClient( );

/** *
 Disable automatic dcop registration
 Must be called before creating a KApplication instance to have an effect.
   
*/
void kde_KApplication_disableAutoDcopRegistration( );

/** *
 Returns the DCOP name of the service launcher. This will be something like
 klaucher_$host_$uid.

*/
qt_QCString* kde_KApplication_launcher( );

/** *
 Starts a service based on the (translated) name of the service.
 E.g. "Web Browser"

*/
int kde_KApplication_startServiceByName( qt_QString * _name, qt_QString * URL, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** *
 Starts a service based on the (translated) name of the service.
 E.g. "Web Browser"

*/
int kde_KApplication_startServiceByName1( qt_QString * _name, qt_QStringList* URLs, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** *
 Starts a service based on the desktop path of the service.
 E.g. "Applications/konqueror.desktop" or "/home/user/bla/myfile.desktop"

*/
int kde_KApplication_startServiceByDesktopPath( qt_QString * _name, qt_QString * URL, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** *
 Starts a service based on the desktop path of the service.
 E.g. "Applications/konqueror.desktop" or "/home/user/bla/myfile.desktop"

*/
int kde_KApplication_startServiceByDesktopPath1( qt_QString * _name, qt_QStringList* URLs, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** *
 Starts a service based on the desktop name of the service.
 E.g. "konqueror"

*/
int kde_KApplication_startServiceByDesktopName( qt_QString * _name, qt_QString * URL, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** *
 Starts a service based on the desktop name of the service.
 E.g. "konqueror"

*/
int kde_KApplication_startServiceByDesktopName1( qt_QString * _name, qt_QStringList* URLs, qt_QString* error, qt_QCString* dcopService, int* pid, qt_QCString* startup_id, int noWait);

/** *
 Starts a program via kdeinit.
 There will be no application startup notification, so you should
 use it only for starting internal processes.

 program name and arguments are converted to according to the
 local encoding and passed as is to kdeinit.

*/
int kde_KApplication_kdeinitExec( qt_QString * name, qt_QStringList* args, qt_QString* error, int* pid);

/** *
 Starts a program via kdeinit and wait for it to finish.

 Like @ref kdeinitExec(), but it waits till the program is finished.
 As such it behaves similar to the system(...) function.

*/
int kde_KApplication_kdeinitExecWait( qt_QString * name, qt_QStringList* args, qt_QString* error, int* pid);

/** *
 Generates a uniform random number.

*/
int kde_KApplication_random( );

/** *
 Generates a random string.  It operates in the range [A-Za-z0-9]

*/
qt_QString * kde_KApplication_randomString( int length);

/** *
 Returns the currently pressed keyboard modifiers (e.g. shift, control, etc.)
 Usually you simply want to test for those in key events, in which case
 @ref QKeyEvent::state() does the job (or @ref QKeyEvent::key() to 
 notice when a modifier is pressed alone).
 But it can be useful to query for the status of the modifiers at another moment
 (e.g. some KDE apps do that upon a drop event).

*/
unsigned int kde_KApplication_keyboardModifiers( );

/** *
 Returns the currently pressed mouse buttons.
 Usually you simply want to test for those in mouse events, in which case
 @ref QMouseEvent::button() does the job (or @ref QMouseEvent::state()).
 But it can be useful to query for the status of the mouse buttons at another moment.
 To query for the mouse pointer position, use @ref QCursor::pos().

*/
unsigned int kde_KApplication_mouseState( );

/** *

   
*/
void kde_KApplication_startKdeinit( );

/** *
 Used to obtain the QPalette that will be used to set the application palette.

 This is only useful for configuration modules such as krdb and should not be
 used in normal circumstances.

*/
qt_QPalette * kde_KApplication_createApplicationPalette( );

/** *

 Raw access for use by KDM.
   
*/
qt_QPalette * kde_KApplication_createApplicationPalette1( kde_KConfig* config, int contrast);

/** *

   
*/
kde_KApplication * kde_new_KApplication3(int allowStyles, int GUIenabled, kde_KInstance* _instance);
void kde_KApplication_virtual_hook(kde_KApplication* instPointer,int identifier, void* data);

/** Casts a 'kde_KApplication *' to a 'kde_KInstance*' */
kde_KInstance* kde_KApplication_KInstance(kde_KApplication* instPointer);

/** Casts a 'kde_KApplication *' to a 'qt_QApplication*' */
qt_QApplication* kde_KApplication_QApplication(kde_KApplication* instPointer);

#endif
