/***************************************************************************
                            kde_KLibFactory.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLIBFACTORY
#define KDE_KLIBFACTORY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 If you develop a library that is to be loaded dynamically at runtime, then
 you should return a pointer to your factory. The K_EXPORT_COMPONENT_FACTORY
 macro is provided for this purpose:
 <pre>
   K_EXPORT_COMPONENT_FACTORY( libkspread, KSpreadFactory )
 </pre>

 The first macro argument is the name of your library, the second specifies the name
 of your factory.

 In the constructor of your factory you should create an instance of @ref KInstance
 like this:
 <pre>
     s_global = new KInstance( "kspread" );
 </pre>
 This @ref KInstance is comparable to @ref KGlobal used by normal applications.
 It allows you to find resource files (images, XML, sound etc.) belonging
 to the library.

 If you want to load a library, use @ref KLibLoader. You can query @ref KLibLoader
 directly for a pointer to the libraries factory by using the @ref KLibLoader::factory()
 function.

 The KLibFactory is used to create the components, the library has to offer.
 The factory of KSpread for example will create instances of KSpreadDoc,
 while the Konqueror factory will create KonqView widgets.
 All objects created by the factory must be derived from @ref QObject, since @ref QObject
 offers type safe casting.

 KLibFactory is an abstract class. Reimplement the @ref
 createObject() method to give it functionality.

 @author Torben Weis <weis@kde.org>
 
 @short *
 If you develop a library that is to be loaded dynamically at runtime, then
 you should return a pointer to your factory.
*/
void kde_del_KLibFactory( kde_KLibFactory* p );

/** *
 Creates a new object. The returned object has to be derived from
 the requested classname.

 It is valid behavior to create different kinds of objects
 depending on the requested @p classname. For example a koffice
 library may usually return a pointer to KoDocument.  But
 if asked for a "QWidget", it could create a wrapper widget,
 that encapsulates the Koffice specific features.

 create() automatically emits a signal @ref objectCreated to tell
 the library about its newly created object.  This is very
 important for reference counting, and allows unloading the
 library automatically once all its objects have been destroyed.

*/
qt_QObject * kde_KLibFactory_create(kde_KLibFactory* instPointer,qt_QObject * parent, char* name, char* classname, qt_QStringList* args);

#endif
