/***************************************************************************
                            kde_TransferJob.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_TRANSFERJOB
#define KDE_TRANSFERJOB

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The transfer job pumps data into and/or out of a Slave.
 Data is sent to the slave on request of the slave (@ref #dataReq).
 If data coming from the slave can not be handled, the
 reading of data from the slave should be suspended.
     
 @short *
 The transfer job pumps data into and/or out of a Slave.
*/
kde_TransferJob * kde_new_TransferJob(kde_KURL* url, int command, qt_QByteArray* packedArgs, qt_QByteArray* _staticData, int showProgressInfo);
void kde_TransferJob_start(kde_TransferJob* instPointer,kde_Slave* slave);

/** *
 Called when m_subJob finishes.
         
*/
void kde_TransferJob_slotResult(kde_TransferJob* instPointer,kde_Job* job);

/** *
 Flow control. Suspend data processing from the slave.
         
*/
void kde_TransferJob_suspend(kde_TransferJob* instPointer);

/** *
 Flow control. Resume data processing from the slave.
         
*/
void kde_TransferJob_resume(kde_TransferJob* instPointer);

/** *
 Flow control. Returns true if the job is suspended.
         
*/
int kde_TransferJob_isSuspended(kde_TransferJob* instPointer);

/** *

*/
int kde_TransferJob_isErrorPage(kde_TransferJob* instPointer);
void kde_TransferJob_virtual_hook(kde_TransferJob* instPointer,int identifier, void* data);
void kde_TransferJob_slotRedirection(kde_TransferJob* instPointer,kde_KURL* url);
void kde_TransferJob_slotFinished(kde_TransferJob* instPointer);
void kde_TransferJob_slotData(kde_TransferJob* instPointer,qt_QByteArray* data);
void kde_TransferJob_slotDataReq(kde_TransferJob* instPointer);
void kde_TransferJob_slotMimetype(kde_TransferJob* instPointer,qt_QString * mimetype);
void kde_TransferJob_slotNeedSubURLData(kde_TransferJob* instPointer);
void kde_TransferJob_slotSubURLData(kde_TransferJob* instPointer,kde_Job* arg1, qt_QByteArray* arg2);
void kde_TransferJob_slotErrorPage(kde_TransferJob* instPointer);
//void kde_TransferJob_slotCanResume(kde_TransferJob* instPointer,KIO::filesize_t offset);

#endif
