/***************************************************************************
                            KKeySequence.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KKeySequence object holds a sequence of up to 4 keys.
 Ex: Ctrl+X,I

 @short *
 A KKeySequence object holds a sequence of up to 4 keys.
*/
public class  KKeySequence implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KKeySequence(Class dummy){}

	private native void newKKeySequence();

/** 
 Create a new null key sequence.

*/
	public KKeySequence() {
		newKKeySequence();
	}
	private native void newKKeySequence( QKeySequence keySeq);

/** 
 Copies the given qt key sequence.

*/
	public KKeySequence( QKeySequence keySeq) {
		newKKeySequence( keySeq);
	}
	private native void newKKeySequence( KKey key);

/** 
 Create a new key sequence that only contains the given key.

*/
	public KKeySequence( KKey key) {
		newKKeySequence( key);
	}
//	private native void newKKeySequence( KKeyNative key);

/** 
 Create a new key sequence that only contains the given key.

*/
//	public KKeySequence( KKeyNative key) {
//		newKKeySequence( key);
//	}
	private native void newKKeySequence( KKeySequence keySeq);

/** 
 Copies the given key sequence.

*/
	public KKeySequence( KKeySequence keySeq) {
		newKKeySequence( keySeq);
	}
	private native void newKKeySequence( String keySeq);

/** 
 Creates a new key sequence that contains the given key sequence. 
 The description consists of comma-separated keys as
 required by {@link KKey#KKey}.

*/
	public KKeySequence( String keySeq) {
		newKKeySequence( keySeq);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Clears the key sequence. The key sequence is null after calling this 
 function.

*/
	public native void clear();

/** 
 Copies the given qt key sequence over this key sequence.

*/
	public native boolean init( QKeySequence keySeq);

/** 
 Initializes the key sequence to only contain the given key.

*/
	public native boolean init( KKey key);

/** 
 Initializes the key sequence to only contain the given key.

*/
//	public native boolean init( KKeyNative key);

/** 
 Copies the given key sequence over this key sequence.

*/
	public native boolean init( KKeySequence keySeq);

/** 
 Initializes this key sequence to contain the given key sequence.
 The description consists of comma-separated keys as
 required by {@link KKey#KKey}.

*/
	public native boolean init( String key);

/** 
 Returns the number of key strokes of this sequence.

*/
	public native int count();

/** 
 Return the <code>i</code>'th key of this sequence, or a null key if there
 are less then i keys.

*/
	public native KKey key( int i);

/** 

	 
*/
	public native boolean isTriggerOnRelease();

/** 
 Sets the <code>i</code>'th key of the sequence. You can not introduce gaps
 in a sequence, so you must use an <code>i</code> <= {@link #count}. Also note that
 the maximum length of a key sequence is {@link MAX_KEYS}.

*/
	public native boolean setKey( int i, KKey key);

/** 

	 
*/
	public native void setTriggerOnRelease( boolean arg1);

/** 
 Returns true if the key sequence is null (after {@link #clear} or empty
 constructor).

*/
	public native boolean isNull();

/** 
 Returns true if this key sequence begins with the given sequence.

*/
	public native boolean startsWith( KKeySequence keySeq);

/** 
 Compares this object with the given key sequence. Returns a negative 
 number if the given KKeySequence is larger, 0 if they are equal and
 a positive number this KKeySequence is larger. Key sequences are
 compared by comparing the individual keys, starting from the beginning
 until an unequal key has been found. If a sequence contains more
 keys, it is considered larger.

*/
	public native int compare( KKeySequence keySeq);

/** 
 Converts this key sequence to a QKeySequence.

*/
	public native QKeySequence qt();

/** 
 Returns the qt key code of the first key.

*/
	public native int keyCodeQt();

/** 
 Returns the key sequence as a number of key presses as
 returned by {@link KKey#toString}, seperated by commas.

*/
	public native String toString();

/** 

	 
*/
	public native String toStringInternal();

/** 
 Returns a null key sequence.

*/
	public static native KKeySequence nullKeySequence();
	public static final int MAX_KEYS = 4;
}
