package org.kde.koala;
import org.kde.qt.*;
import java.io.ByteArrayOutputStream;

/** {@link MimetypeJob} emits these signals */
public interface MimetypeJobSignals {

/** 
 Emitted when the slave successfully connected to the host.
 There is no guarantee the slave will send this, and this is
 currently unused (in the applications).
         
*/
	void connected( Job arg1 );

/** 
 Request for data.
 Please note, that you shouldn't put too large chunks
 of data in it as this requires copies within the frame
 work, so you should rather split the data you want
 to pass here in reasonable chunks (about 1MB maximum)

*/
	void dataReq( Job arg1, ByteArrayOutputStream data );

/** 
 Emitted to display information about the speed of this job.
         
*/
	void speed( Job arg1, long bytes_per_second );

/** 
 Emitted when the job is finished, in any case (completed, canceled,
 failed...). Use {@link MimetypeJob#error} to know the result.
         
*/
	void result( Job job );

/** 
 Regularly emitted to show the progress of this job
 (current data size for transfers, entries listed).
         
*/
	void processedSize( Job arg1, int size );

/** 
 Signals a redirection.
 Use to update the URL shown to the user.
 The redirection itself is handled internally.
         
*/
	void redirection( Job arg1, KURL url );

/** 
 Emitted to display information about this job, as sent by the slave.
 Examples of message are "Resolving host", "Connecting to host...", etc.
         
*/
	void infoMessage( Job arg1, String msg );
	void destroyed( QObject obj );

/** 
 Data from the slave has arrived.

*/
	void data( Job arg1, byte[] data );

/** 
 Signals a permanent redirection.
 The redirection itself is handled internally.

*/
	void permanentRedirection( Job arg1, KURL fromUrl, KURL toUrl );

/** 
 Emitted when the job is canceled.

 Signal <code>result</code> is emitted as well, and error() is,
 in this case, ERR_USER_CANCELED.
         
*/
	void canceled( Job job );

/** 

 Emitted if the "put" job found an existing partial file
 (in which case offset is the size of that file)
 and emitted by the "get" job if it supports resuming to
 the given offset - in this case <code>offset</code> is unused)
         
*/
	void canResume( Job arg1, int offset );

/** 
 Progress signal showing the overall progress of the job
 This is valid for any kind of job, and allows using a
 a progress bar very easily. (see {@link KProgress}).
 Note that this signal is not emitted for finished jobs
 (i.e. percent is never 100).
         
*/
	void percent( Job job, long percent );

/** 
 Emitted when we know the size of this job (data size for transfers,
 number of entries for listings).
         
*/
	void totalSize( Job arg1, int size );
}

