/***************************************************************************
                            KEditListBox.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDITLISTBOX_H
#define KEDITLISTBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QGroupBox.h>

/**

 An editable listbox

 This class provides a editable listbox ;-), this means
 a listbox which is accompanied by a line edit to enter new
 items into the listbox and pushbuttons to add and remove
 items from the listbox and two buttons to move items up and down.
 
 @short 
 An editable listbox

*/

@class QListBox;
@class KLineEdit;
@class QPushButton;

@interface KEditListBox : QGroupBox 

/** 
 Create an editable listbox.

 If @p checkAtEntering is true, after every character you type
 in the line edit KEditListBox will enable or disable
 the Add-button, depending whether the current content of the
 line edit is already in the listbox. Maybe this can become a
 performance hit with large lists on slow machines.
 If @p checkAtEntering is false,
 it will be checked if you press the Add-button. It is not
 possible to enter items twice into the listbox.
       
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name checkAtEntering: (BOOL)checkAtEntering buttons: (int)buttons;
- init;

/** 
 Create an editable listbox.

 The same as the other constructor, additionally it takes
 @title, which will be the title of the frame around the listbox.
       
*/
- initWithText: (NSString *)title parent: (QWidget *)parent name: (NSString *)name checkAtEntering: (BOOL)checkAtEntering buttons: (int)buttons;
- initWithText: (NSString *)title ;
- (void) dealloc;

/** 
 Return a pointer to the embedded QListBox.
       
*/
- (QListBox*) listBox;

/** 
 Return a pointer to the embedded QLineEdit.
       
*/
- (KLineEdit*) lineEdit;

/** 
 Return a pointer to the Add button
       
*/
- (QPushButton*) addButton;

/** 
 Return a pointer to the Remove button
       
*/
- (QPushButton*) removeButton;

/** 
 Return a pointer to the Up button
       
*/
- (QPushButton*) upButton;

/** 
 Return a pointer to the Down button
       
*/
- (QPushButton*) downButton;

/** 
 See @ref -[QListBox count]
       
*/
- (int) count;

/** 
 See @ref -[QListBox insertStringList]
       
*/
- insertStringList: (NSArray *)list index: (int)index;
- insertStringList: (NSArray *)list ;

/** 
 See @ref -[QListBox insertStringList]
       
*/
- insertStrList: (NSArray *)list index: (int)index;
- insertStrList: (NSArray *)list ;

/** 
 See @ref -[QListBox insertStrList]
       
*/
//- insertStrList: (NSArray *)list index: (int)index;
//- insertStrList: (NSArray *)list ;

/** 
 See @ref -[QListBox insertStrList]
       
*/
- insertStrListFromString: (NSString *)list numStrings: (int)numStrings index: (int)index;
- insertStrListFromString: (NSString *)list ;

/** 
 See @ref -[QListBox insertItem]
       
*/
- insertTextItem: (NSString *)text index: (int)index;
- insertTextItem: (NSString *)text ;

/** 
 Clears both the listbox and the line edit.
       
*/
- clear;

/** 
 See @ref -[QListBox text]
       
*/
- (NSString *) text: (int)index;

/** 
 See @ref -[QListBox currentItem]
       
*/
- (int) currentItem;

/** 
 See @ref -[QListBox currentText]
       
*/
- (NSString *) currentText;

/** 

*/
- (NSArray *) items;
- virtual_hook: (int)identifier data: (void*)data;
- moveItemUp;
- moveItemDown;
- addItem;
- removeItem;
- enableMoveButtons: (int)index;
- typedSomething: (NSString *)text;
+ (int) Add;
+ (int) Remove;
+ (int) UpDown;
+ (int) All;
@end

/** Override these methods in subclasses of KEditListBox to customise event handling behaviour */
@protocol KEditListBoxEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
