/***************************************************************************
                            KIntValidator.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KINTVALIDATOR_H
#define KINTVALIDATOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QValidator.h>

/**

  @ref QValidator for integers.

  This can be used by @ref QLineEdit or subclass to provide validated
  text entry.  Can be provided with a base value (default is 10), to allow
  the proper entry of hexadecimal, octal, or any other base numeric data.

 @author Glen Parker <glenebob@nwlink.com>

 @version 0.0.1

 @short 
  @ref QValidator for integers.
*/
@interface KIntValidator : QValidator 

/** 
      Constuctor.  Also sets the base value.
    
*/
- initWithWidget: (QWidget *)parent base: (int)base name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;

/** 
 Constructor.  Also sets the minimum, maximum, and numeric base values.
     
*/
- initWithInt: (int)bottom top: (int)top parent: (QWidget *)parent base: (int)base name: (NSString *)name;
- initWithInt: (int)bottom top: (int)top parent: (QWidget *)parent ;

/** 
 Destructs the validator.
     
*/
- (void) dealloc;

/** 
 Validates the text, and return the result.  Does not modify the parameters.
     
*/
- (int) validate: (NSString *)arg1 int: (int)arg2;

/** 
 Fixes the text if possible, providing a valid string.  The parameter may be modified.
     
*/
- fixup: (NSString *)arg1;

/** 
 Sets the minimum and maximum values allowed.
     
*/
- setRange: (int)bottom top: (int)top;

/** 
 Sets the numeric base value.
     
*/
- setBase: (int)base;

/** 
 Returns the current minimum value allowed.
     
*/
- (int) bottom;

/** 
 Returns the current maximum value allowed.
     
*/
- (int) top;

/** 
 Returns the current numeric base.
     
*/
- (int) base;
@end

/** Override these methods in subclasses of KIntValidator to customise event handling behaviour */
@protocol KIntValidatorEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
