/***************************************************************************
                            KURIFilter.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURIFILTER_H
#define KURIFILTER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Manages the filtering of a URI.

 The intention of this plugin class is to allow people to extend
 the functionality of KURL without modifying it directly.  This
 way KURL will remain a generic parser capable of parsing any
 generic URL that adheres to specifications.

 The KURIFilter class applies a number of filters to a URI,
 and returns the filtered version whenever possible. The filters
 are implemented using plugins to provide easy extensibility
 of the filtering mechanism.  That is, new filters can be added in
 the future by simply inheriting from @ref KURIFilterPlugin and
 implementing the @ref -[KURIFilterPlugin filterURI]method.

 Use of this plugin-manager class is straight forward.  Since
 it is a singleton object, all you have to do is obtain an instance
 by doing @p -[KURIFilter self] and use any of the public member
 functions to preform the filtering.

 To simply filter a given string:
 <pre>
 bool filtered = -[KURIFilter self]->filterURI( "kde.org" );
 </pre>

 You can alternatively use a KURL:
 <pre>
 KURL url = "kde.org";
 bool filtered = -[KURIFilter self]->filterURI( url );
 </pre>

 If you have a constant string or a constant URL,
 simply invoke the corresponding function to obtain
 the filtered string or URL instead of a boolean flag:
 <pre>
 QString u = -[KURIFilter self]->filteredURI( "kde.org" );
 </pre>

 You can also specify only specific filter(s) to be applied
 by supplying the name(s) of the filter(s).  By defualt all
 filters that are found are loaded when the KURIFilter object
 is created will be used.  These names are taken from the
 enteries in the \".desktop\" files.  Here are a couple of
 examples:
 <pre>
 QString text = "kde.org";
 bool filtered = -[KURIFilter self]->filterURI( text, "KShortURIFilter" );

 QStringList list;
 list << "KShortURIFilter" << "MyFilter";
 bool filtered = -[KURIFilter self]->filterURI( text, list );
 </pre>

 KURIFilter also allows richer data exchange through a simple
 meta-object called @p KURIFilterData.  Using this meta-object
 you can find out more information about the URL you want to
 filter.  See @ref KURIFilterData for examples and details.

 @short Filters a given URL into its proper format whenever possible.
 
*/
@class KURIFilterData; 
@class KURL; 

@interface  KURIFilter : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Filters the URI given by the object URIFilterData.

 This filters the given data based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
//- (BOOL) filterURIData: (KURIFilterData*)data filters: (NSArray *)filters;
//- (BOOL) filterURIData: (KURIFilterData*)data ;

/** 
 Filters the URI given by the URL.

 This filters the given URL based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
- (BOOL) filterURI: (KURL*)uri filters: (NSArray *)filters;
//- (BOOL) filterURI: (KURL*)uri ;

/** 
 Filters a string representing a URI.

 This filters the given string based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
- (BOOL) filterURIWithName: (NSString *)uri filters: (NSArray *)filters;
//- (BOOL) filterURIWithName: (NSString *)uri ;

/** 
 Returns the filtered URI.

 This filters the given URL based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
- (KURL*) filteredURI: (KURL*)uri filters: (NSArray *)filters;
//- (KURL*) filteredURI: (KURL*)uri ;

/** 
 Return a filtered string representation of a URI.

 This filters the given URL based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
- (NSString *) filteredURIWithName: (NSString *)uri filters: (NSArray *)filters;

/** 
 Return a static instance of KURIFilter.
     
*/
+ (KURIFilter*) self;

/** 
 A protected constructor.

 This constructor creates a KURIFilter and
 initializes all plugins it can find by invoking
 @ref loadPlugins.
     
*/
- init;

/** 
 Loads all allowed plugins.

 This function loads all filters that have not
 been dis
     
*/
- loadPlugins;
@end

#endif
