/***************************************************************************
                            KValueSelector.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KVALUESELECTOR_H
#define KVALUESELECTOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KSelector.h>

/**

 Widget for color value selection.

 @author Martin Jones (mjones@kde.org)

 @version $Id: KValueSelector.h,v 1.3 2002/03/15 02:12:24 rdale Exp $
 
 @short 
 Widget for color value selection.
*/
@interface KValueSelector : KSelector 

/** 
 Constructs a widget for color selection.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a widget for color selection with a given orientation
   
*/
- initWithInt: (int)o parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)o ;
- (int) hue;
- setHue: (int)h;
- (int) saturation;
- setSaturation: (int)s;
- updateContents;

/** 
 Draws the contents of the widget on a pixmap,
 which is used for buffering.
   
*/
- drawPalette: (QPixmap *)pixmap;

/** 
 Reimplemented from KSelector. The drawing is
 buffered in a pixmap here. As real drawing
 routine, -drawPalette is used.
   
*/
- drawContents: (QPainter *)painter;
@end

/** Override these methods in subclasses of KValueSelector to customise event handling behaviour */
@protocol KValueSelectorEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 

   
*/
- mousePressEvent:(QMouseEvent*) e;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;

/** 

   
*/
- mouseMoveEvent:(QMouseEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 

   
*/
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 

   
*/
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
