/***************************************************************************
                            QDataTable.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QDATATABLE_H
#define QDATATABLE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QTable.h>

@class QIconSet; 
@class QSqlCursor; 
@class QSqlEditorFactory; 
@class QSqlError; 
@class QSqlField; 
@class QSqlIndex; 
@class QSqlPropertyMap; 
@class QSqlRecord; 

@interface QDataTable : QTable 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- initWithSqlCursor: (QSqlCursor*)cursor autoPopulate: (BOOL)autoPopulate parent: (QWidget *)parent name: (NSString *)name;
- initWithSqlCursor: (QSqlCursor*)cursor ;
- (void) dealloc;
- addColumn: (NSString *)fieldName label: (NSString *)label width: (int)width iconset: (QIconSet*)iconset;
- addColumn: (NSString *)fieldName ;
- removeColumn: (unsigned int)col;
- setColumn: (unsigned int)col fieldName: (NSString *)fieldName label: (NSString *)label width: (int)width iconset: (QIconSet*)iconset;
- setColumn: (unsigned int)col fieldName: (NSString *)fieldName ;
- (NSString *) nullText;
- (NSString *) trueText;
- (NSString *) falseText;
- (int) dateFormat;
- (BOOL) confirmEdits;
- (BOOL) confirmInsert;
- (BOOL) confirmUpdate;
- (BOOL) confirmDelete;
- (BOOL) confirmCancels;
- (BOOL) autoDelete;
- (BOOL) autoEdit;
- (NSString *) filter;
- (NSArray *) sort;
- setSqlCursor: (QSqlCursor*)cursor autoPopulate: (BOOL)autoPopulate autoDelete: (BOOL)autoDelete;
- setSqlCursor;
- (QSqlCursor*) sqlCursor;
- setNullText: (NSString *)nullText;
- setTrueText: (NSString *)trueText;
- setFalseText: (NSString *)falseText;
- setDateFormat: (int)f;
- setConfirmEdits: (BOOL)confirm;
- setConfirmInsert: (BOOL)confirm;
- setConfirmUpdate: (BOOL)confirm;
- setConfirmDelete: (BOOL)confirm;
- setConfirmCancels: (BOOL)confirm;
- setAutoDelete: (BOOL)enable;
- setAutoEdit: (BOOL)autoEdit;
- setFilter: (NSString *)filter;
- setSortFromStringList: (NSArray *)sort;
- setSort: (QSqlIndex*)sort;
- refresh: (int)mode;
- sortColumn: (int)col ascending: (BOOL)ascending wholeRows: (BOOL)wholeRows;
- sortColumn: (int)col ;
- (NSString *) text: (int)row col: (int)col;
- (QVariant*) value: (int)row col: (int)col;
- (QSqlRecord*) currentRecord;
- installEditorFactory: (QSqlEditorFactory*)f;
- installPropertyMap: (QSqlPropertyMap*)m;
- (int) numCols;
- (int) numRows;
- setNumCols: (int)c;
- setNumRows: (int)r;
- (BOOL) findBuffer: (QSqlIndex*)idx atHint: (int)atHint;
- (BOOL) findBuffer: (QSqlIndex*)idx ;
- find: (NSString *)str caseSensitive: (BOOL)caseSensitive backwards: (BOOL)backwards;
- sortAscending: (int)col;
- sortDescending: (int)col;
- refresh;
- setColumnWidth: (int)col w: (int)w;
- (BOOL) insertCurrent;
- (BOOL) updateCurrent;
- (BOOL) deleteCurrent;
- (int) confirmEdit: (int)m;
- (int) confirmCancel: (int)m;
- handleError: (QSqlError*)e;
- (BOOL) beginInsert;
- (QWidget*) beginUpdate: (int)row col: (int)col replace: (BOOL)replace;
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
- endEdit: (int)row col: (int)col accept: (BOOL)accept replace: (BOOL)replace;
- (QWidget*) createEditor: (int)row col: (int)col initFromCell: (BOOL)initFromCell;
- activateNextCell;
- (int) indexOf: (unsigned int)i;
- reset;
- setSize: (QSqlCursor*)sql;
- repaintCell: (int)row col: (int)col;
- paintCell: (QPainter *)p row: (int)row col: (int)col cr: (QRect*)cr selected: (BOOL)selected cg: (QColorGroup *)cg;
- paintField: (QPainter *)p field: (QSqlField*)field cr: (QRect*)cr selected: (BOOL)selected;
- (int) fieldAlignment: (QSqlField*)field;
- columnClicked: (int)col;
- resizeData: (int)len;
- (QTableItem*) item: (int)row col: (int)col;
- setItem: (int)row col: (int)col item: (QTableItem*)item;
- clearCell: (int)row col: (int)col;
- setPixmap: (int)row col: (int)col pix: (QPixmap *)pix;
- takeItem: (QTableItem*)i;
+ (int) RefreshData;
+ (int) RefreshColumns;
+ (int) RefreshAll;
@end

/** Override these methods in subclasses of QDataTable to customise event handling behaviour */
@protocol QDataTableEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) e;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- dropEvent:(QDropEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- contentsMousePressEvent:(QMouseEvent*) e;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
@end


#endif
