namespace Binge.Generators
{
	using System;
	using System.Collections;
	using Binge.Bits;

	public abstract class Converter: Binge.Bits.Object
	{
		private bool usePascalCase;
		private Namespace nspace;

		/* If set, the first letter of all member names will be capitalized. */
		public bool UsePascalCase
		{
			get { return usePascalCase; }
			set { usePascalCase = value; }
		}

		/* While not required, specifying the working namespace can help
		   converters make decisions about how to handle C and C++-style
		   use of enumerations in C#. */
		public Namespace Nspace
		{
			get { return nspace; }
			set { nspace = value; }
		}

		protected Converter ()
		{
			usePascalCase = true;
		}

		public abstract void Convert (Class klass);
		public abstract void Convert (Binge.Bits.Enum enm);
		public abstract void Convert (Field field);
		public abstract void Convert (Property prop);
		public abstract void Convert (Constructor ctor);
		public abstract void Convert (Destructor dtor);
		public abstract void Convert (Method method);
		public abstract void Convert (Interface iface);
	}
}
