/* $Id$
 * 
 * Copyright 2002-2004 Jasper Huijsmans (jasper@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include <gdk/gdk.h>
#include <gtk/gtkbutton.h>

#include "xfce_scaled_image.h"
#include "xfce_iconbutton.h"

#define DEBUGGING 0

/* XXX: this is used by gtkbutton. hope they won't change it soon ... */
#define CHILD_SPACING 1

/* Forward declarations */

static void xfce_iconbutton_class_init (XfceIconbuttonClass * class);
static void xfce_iconbutton_init (XfceIconbutton * iconbutton);

/* Local data */

static GtkWidgetClass *parent_class = NULL;

/* workaround for http://bugzilla.gnome.org/show_bug.cgi?id=142417 */
static void
_style_set_cb(GtkWidget *w, GtkStyle *prev_style, gpointer user_data)
{
    GtkStyle *style;

    if (XFCE_ICONBUTTON (w)->image)
    {
        style = gtk_rc_get_style_by_paths (gtk_settings_get_default (),
            "GtkButton", "GtkButton", GTK_TYPE_BUTTON);
        gtk_widget_set_style (XFCE_ICONBUTTON (w)->image, style);
    }
}

GtkType
xfce_iconbutton_get_type (void)
{
    static GtkType iconbutton_type = 0;

    if (!iconbutton_type)
    {
	static const GTypeInfo iconbutton_info = {
	    sizeof (XfceIconbuttonClass),
	    NULL,		/* base_init */
	    NULL,		/* base_finalize */
	    (GClassInitFunc) xfce_iconbutton_class_init,
	    NULL,		/* class_finalize */
	    NULL,		/* class_data */
	    sizeof (XfceIconbutton),
	    0,			/* n_preallocs */
	    (GInstanceInitFunc) xfce_iconbutton_init,
	    NULL		/* value_table */
	};

	iconbutton_type =
	    g_type_register_static (GTK_TYPE_BUTTON, "XfceIconbutton",
				    &iconbutton_info, 0);
    }

    return iconbutton_type;
}

static void
xfce_iconbutton_class_init (XfceIconbuttonClass * class)
{
    parent_class = gtk_type_class (gtk_button_get_type ());
}

static void
xfce_iconbutton_init (XfceIconbutton * iconbutton)
{
    iconbutton->image = xfce_scaled_image_new ();
    gtk_widget_show (iconbutton->image);
    gtk_container_add (GTK_CONTAINER (iconbutton), iconbutton->image);

    iconbutton->icon_width = iconbutton->icon_height = -1;
    iconbutton->pb = NULL;
}

GtkWidget *
xfce_iconbutton_new (void)
{
    GtkWidget *iconbutton = GTK_WIDGET (g_object_new (xfce_iconbutton_get_type (), NULL));

    g_signal_connect (G_OBJECT (iconbutton), "style-set",
        G_CALLBACK (_style_set_cb), NULL);

    return iconbutton;
}

GtkWidget *
xfce_iconbutton_new_from_pixbuf (GdkPixbuf * pixbuf)
{
    GtkWidget *iconbutton;

    iconbutton = xfce_iconbutton_new ();
    xfce_iconbutton_set_pixbuf (XFCE_ICONBUTTON (iconbutton), pixbuf);

    return iconbutton;
}

void
xfce_iconbutton_set_pixbuf (XfceIconbutton * iconbutton, GdkPixbuf * pixbuf)
{
    g_return_if_fail (iconbutton != NULL);
    g_return_if_fail (XFCE_IS_ICONBUTTON (iconbutton));

    xfce_scaled_image_set_from_pixbuf (XFCE_SCALED_IMAGE (iconbutton->image),
	    			       pixbuf);
}
