--TEST--
htmlentities() conformance check (HTML 5)
--FILE--
<?php
function utf32_utf8($k) {
	if ($k < 0x80) {
		$retval = pack('C', $k);
	} else if ($k < 0x800) {
		$retval = pack('C2', 
            0xc0 | ($k >> 6),
            0x80 | ($k & 0x3f));
	} else if ($k < 0x10000) {
        $retval = pack('C3',
            0xe0 | ($k >> 12),
            0x80 | (($k >> 6) & 0x3f),
            0x80 | ($k & 0x3f));
	} else {
        $retval = pack('C4',
            0xf0 | ($k >> 18),
            0x80 | (($k >> 12) & 0x3f),
            0x80 | (($k >> 6) & 0x3f),
            0x80 | ($k & 0x3f));
	}
	return $retval;
}

for ($i = 0; $i < 0x1DFFF; $i++) {
    if ($i >= 0xd800 && $i < 0xe000) //surrogates
        continue;
    $str = utf32_utf8($i);
    $result = htmlentities($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    if ($str != $result) {
        printf("%s\tU+%05X\n", $result, $i);
    }
}

/* multicodepoint entities */
$mpcent = array(
array(0x0003C, 0x20D2),
array(0x0003D, 0x20E5),
array(0x0003E, 0x20D2),
array(0x00066, 0x6A),
array(0x0205F, 0x200A),
array(0x0219D, 0x338),
array(0x02202, 0x338),
array(0x02220, 0x20D2),
array(0x02229, 0xFE00),
array(0x0222A, 0xFE00),
array(0x0223C, 0x020D2),
array(0x0223D, 0x00331),
array(0x0223E, 0x00333),
array(0x02242, 0x338),
array(0x0224B, 0x338),
array(0x0224D, 0x020D2),
array(0x0224E, 0x338),
array(0x0224F, 0x338),
array(0x02250, 0x338),
array(0x02261, 0x020E5),
array(0x02264, 0x20D2),
array(0x02265, 0x020D2),
array(0x02266, 0x338),
array(0x02267, 0x00338),
array(0x02268, 0xFE00),
array(0x02269, 0xFE00),
array(0x0226A, 0x338),
array(0x0226A, 0x20D2),
array(0x0226B, 0x338),
array(0x0226B, 0x20D2),
array(0x0227F, 0x338),
array(0x02282, 0x20D2),
array(0x02283, 0x20D2),
array(0x0228A, 0xFE00),
array(0x0228B, 0xFE00),
array(0x0228F, 0x338),
array(0x02290, 0x338),
array(0x02293, 0xFE00),
array(0x02294, 0xFE00),
array(0x022B4, 0x20D2),
array(0x022B5, 0x20D2),
array(0x022D8, 0x338),
array(0x022D9, 0x338),
array(0x022DA, 0xFE00),
array(0x022DB, 0xFE00),
array(0x022F5, 0x338),
array(0x022F9, 0x338),
array(0x02933, 0x338),
array(0x029CF, 0x338),
array(0x029D0, 0x338),
array(0x02A6D, 0x338),
array(0x02A70, 0x338),
array(0x02A7D, 0x338),
array(0x02A7E, 0x338),
array(0x02AA1, 0x338),
array(0x02AA2, 0x338),
array(0x02AAC, 0xFE00),
array(0x02AAD, 0xFE00),
array(0x02AAF, 0x338),
array(0x02AB0, 0x338),
array(0x02AC5, 0x338),
array(0x02AC6, 0x338),
array(0x02ACB, 0xFE00),
array(0x02ACC, 0xFE00),
array(0x02AFD, 0xFE00),
);

foreach ($mpcent as $i) {
    $str = utf32_utf8($i[0]);
    $str .= utf32_utf8($i[1]);
    $result = htmlentities($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    printf("%s\tU+%05X U+%05X\n", $result, $i[0], $i[1]);
}
?>
--EXPECT--
&Tab;	U+00009
&NewLine;	U+0000A
&excl;	U+00021
&quot;	U+00022
&num;	U+00023
&dollar;	U+00024
&percnt;	U+00025
&amp;	U+00026
&apos;	U+00027
&lpar;	U+00028
&rpar;	U+00029
&ast;	U+0002A
&plus;	U+0002B
&comma;	U+0002C
&period;	U+0002E
&sol;	U+0002F
&colon;	U+0003A
&semi;	U+0003B
&lt;	U+0003C
&equals;	U+0003D
&gt;	U+0003E
&quest;	U+0003F
&commat;	U+00040
&lbrack;	U+0005B
&bsol;	U+0005C
&rsqb;	U+0005D
&Hat;	U+0005E
&lowbar;	U+0005F
&grave;	U+00060
&lbrace;	U+0007B
&vert;	U+0007C
&rcub;	U+0007D
&nbsp;	U+000A0
&iexcl;	U+000A1
&cent;	U+000A2
&pound;	U+000A3
&curren;	U+000A4
&yen;	U+000A5
&brvbar;	U+000A6
&sect;	U+000A7
&DoubleDot;	U+000A8
&copy;	U+000A9
&ordf;	U+000AA
&laquo;	U+000AB
&not;	U+000AC
&shy;	U+000AD
&reg;	U+000AE
&macr;	U+000AF
&deg;	U+000B0
&plusmn;	U+000B1
&sup2;	U+000B2
&sup3;	U+000B3
&DiacriticalAcute;	U+000B4
&micro;	U+000B5
&para;	U+000B6
&CenterDot;	U+000B7
&Cedilla;	U+000B8
&sup1;	U+000B9
&ordm;	U+000BA
&raquo;	U+000BB
&frac14;	U+000BC
&half;	U+000BD
&frac34;	U+000BE
&iquest;	U+000BF
&Agrave;	U+000C0
&Aacute;	U+000C1
&Acirc;	U+000C2
&Atilde;	U+000C3
&Auml;	U+000C4
&Aring;	U+000C5
&AElig;	U+000C6
&Ccedil;	U+000C7
&Egrave;	U+000C8
&Eacute;	U+000C9
&Ecirc;	U+000CA
&Euml;	U+000CB
&Igrave;	U+000CC
&Iacute;	U+000CD
&Icirc;	U+000CE
&Iuml;	U+000CF
&ETH;	U+000D0
&Ntilde;	U+000D1
&Ograve;	U+000D2
&Oacute;	U+000D3
&Ocirc;	U+000D4
&Otilde;	U+000D5
&Ouml;	U+000D6
&times;	U+000D7
&Oslash;	U+000D8
&Ugrave;	U+000D9
&Uacute;	U+000DA
&Ucirc;	U+000DB
&Uuml;	U+000DC
&Yacute;	U+000DD
&THORN;	U+000DE
&szlig;	U+000DF
&agrave;	U+000E0
&aacute;	U+000E1
&acirc;	U+000E2
&atilde;	U+000E3
&auml;	U+000E4
&aring;	U+000E5
&aelig;	U+000E6
&ccedil;	U+000E7
&egrave;	U+000E8
&eacute;	U+000E9
&ecirc;	U+000EA
&euml;	U+000EB
&igrave;	U+000EC
&iacute;	U+000ED
&icirc;	U+000EE
&iuml;	U+000EF
&eth;	U+000F0
&ntilde;	U+000F1
&ograve;	U+000F2
&oacute;	U+000F3
&ocirc;	U+000F4
&otilde;	U+000F5
&ouml;	U+000F6
&divide;	U+000F7
&oslash;	U+000F8
&ugrave;	U+000F9
&uacute;	U+000FA
&ucirc;	U+000FB
&uuml;	U+000FC
&yacute;	U+000FD
&thorn;	U+000FE
&yuml;	U+000FF
&Amacr;	U+00100
&amacr;	U+00101
&Abreve;	U+00102
&abreve;	U+00103
&Aogon;	U+00104
&aogon;	U+00105
&Cacute;	U+00106
&cacute;	U+00107
&Ccirc;	U+00108
&ccirc;	U+00109
&Cdot;	U+0010A
&cdot;	U+0010B
&Ccaron;	U+0010C
&ccaron;	U+0010D
&Dcaron;	U+0010E
&dcaron;	U+0010F
&Dstrok;	U+00110
&dstrok;	U+00111
&Emacr;	U+00112
&emacr;	U+00113
&Edot;	U+00116
&edot;	U+00117
&Eogon;	U+00118
&eogon;	U+00119
&Ecaron;	U+0011A
&ecaron;	U+0011B
&Gcirc;	U+0011C
&gcirc;	U+0011D
&Gbreve;	U+0011E
&gbreve;	U+0011F
&Gdot;	U+00120
&gdot;	U+00121
&Gcedil;	U+00122
&Hcirc;	U+00124
&hcirc;	U+00125
&Hstrok;	U+00126
&hstrok;	U+00127
&Itilde;	U+00128
&itilde;	U+00129
&Imacr;	U+0012A
&imacr;	U+0012B
&Iogon;	U+0012E
&iogon;	U+0012F
&Idot;	U+00130
&inodot;	U+00131
&IJlig;	U+00132
&ijlig;	U+00133
&Jcirc;	U+00134
&jcirc;	U+00135
&Kcedil;	U+00136
&kcedil;	U+00137
&kgreen;	U+00138
&Lacute;	U+00139
&lacute;	U+0013A
&Lcedil;	U+0013B
&lcedil;	U+0013C
&Lcaron;	U+0013D
&lcaron;	U+0013E
&Lmidot;	U+0013F
&lmidot;	U+00140
&Lstrok;	U+00141
&lstrok;	U+00142
&Nacute;	U+00143
&nacute;	U+00144
&Ncedil;	U+00145
&ncedil;	U+00146
&Ncaron;	U+00147
&ncaron;	U+00148
&napos;	U+00149
&ENG;	U+0014A
&eng;	U+0014B
&Omacr;	U+0014C
&omacr;	U+0014D
&Odblac;	U+00150
&odblac;	U+00151
&OElig;	U+00152
&oelig;	U+00153
&Racute;	U+00154
&racute;	U+00155
&Rcedil;	U+00156
&rcedil;	U+00157
&Rcaron;	U+00158
&rcaron;	U+00159
&Sacute;	U+0015A
&sacute;	U+0015B
&Scirc;	U+0015C
&scirc;	U+0015D
&Scedil;	U+0015E
&scedil;	U+0015F
&Scaron;	U+00160
&scaron;	U+00161
&Tcedil;	U+00162
&tcedil;	U+00163
&Tcaron;	U+00164
&tcaron;	U+00165
&Tstrok;	U+00166
&tstrok;	U+00167
&Utilde;	U+00168
&utilde;	U+00169
&Umacr;	U+0016A
&umacr;	U+0016B
&Ubreve;	U+0016C
&ubreve;	U+0016D
&Uring;	U+0016E
&uring;	U+0016F
&Udblac;	U+00170
&udblac;	U+00171
&Uogon;	U+00172
&uogon;	U+00173
&Wcirc;	U+00174
&wcirc;	U+00175
&Ycirc;	U+00176
&ycirc;	U+00177
&Yuml;	U+00178
&Zacute;	U+00179
&zacute;	U+0017A
&Zdot;	U+0017B
&zdot;	U+0017C
&Zcaron;	U+0017D
&zcaron;	U+0017E
&fnof;	U+00192
&imped;	U+001B5
&gacute;	U+001F5
&jmath;	U+00237
&circ;	U+002C6
&Hacek;	U+002C7
&Breve;	U+002D8
&dot;	U+002D9
&ring;	U+002DA
&ogon;	U+002DB
&DiacriticalTilde;	U+002DC
&DiacriticalDoubleAcute;	U+002DD
&DownBreve;	U+00311
&Alpha;	U+00391
&Beta;	U+00392
&Gamma;	U+00393
&Delta;	U+00394
&Epsilon;	U+00395
&Zeta;	U+00396
&Eta;	U+00397
&Theta;	U+00398
&Iota;	U+00399
&Kappa;	U+0039A
&Lambda;	U+0039B
&Mu;	U+0039C
&Nu;	U+0039D
&Xi;	U+0039E
&Omicron;	U+0039F
&Pi;	U+003A0
&Rho;	U+003A1
&Sigma;	U+003A3
&Tau;	U+003A4
&Upsilon;	U+003A5
&Phi;	U+003A6
&Chi;	U+003A7
&Psi;	U+003A8
&Omega;	U+003A9
&alpha;	U+003B1
&beta;	U+003B2
&gamma;	U+003B3
&delta;	U+003B4
&epsi;	U+003B5
&zeta;	U+003B6
&eta;	U+003B7
&theta;	U+003B8
&iota;	U+003B9
&kappa;	U+003BA
&lambda;	U+003BB
&mu;	U+003BC
&nu;	U+003BD
&xi;	U+003BE
&omicron;	U+003BF
&pi;	U+003C0
&rho;	U+003C1
&sigmav;	U+003C2
&sigma;	U+003C3
&tau;	U+003C4
&upsi;	U+003C5
&phi;	U+003C6
&chi;	U+003C7
&psi;	U+003C8
&omega;	U+003C9
&thetasym;	U+003D1
&upsih;	U+003D2
&straightphi;	U+003D5
&piv;	U+003D6
&Gammad;	U+003DC
&gammad;	U+003DD
&varkappa;	U+003F0
&rhov;	U+003F1
&straightepsilon;	U+003F5
&backepsilon;	U+003F6
&IOcy;	U+00401
&DJcy;	U+00402
&GJcy;	U+00403
&Jukcy;	U+00404
&DScy;	U+00405
&Iukcy;	U+00406
&YIcy;	U+00407
&Jsercy;	U+00408
&LJcy;	U+00409
&NJcy;	U+0040A
&TSHcy;	U+0040B
&KJcy;	U+0040C
&Ubrcy;	U+0040E
&DZcy;	U+0040F
&Acy;	U+00410
&Bcy;	U+00411
&Vcy;	U+00412
&Gcy;	U+00413
&Dcy;	U+00414
&IEcy;	U+00415
&ZHcy;	U+00416
&Zcy;	U+00417
&Icy;	U+00418
&Jcy;	U+00419
&Kcy;	U+0041A
&Lcy;	U+0041B
&Mcy;	U+0041C
&Ncy;	U+0041D
&Ocy;	U+0041E
&Pcy;	U+0041F
&Rcy;	U+00420
&Scy;	U+00421
&Tcy;	U+00422
&Ucy;	U+00423
&Fcy;	U+00424
&KHcy;	U+00425
&TScy;	U+00426
&CHcy;	U+00427
&SHcy;	U+00428
&SHCHcy;	U+00429
&HARDcy;	U+0042A
&Ycy;	U+0042B
&SOFTcy;	U+0042C
&Ecy;	U+0042D
&YUcy;	U+0042E
&YAcy;	U+0042F
&acy;	U+00430
&bcy;	U+00431
&vcy;	U+00432
&gcy;	U+00433
&dcy;	U+00434
&iecy;	U+00435
&zhcy;	U+00436
&zcy;	U+00437
&icy;	U+00438
&jcy;	U+00439
&kcy;	U+0043A
&lcy;	U+0043B
&mcy;	U+0043C
&ncy;	U+0043D
&ocy;	U+0043E
&pcy;	U+0043F
&rcy;	U+00440
&scy;	U+00441
&tcy;	U+00442
&ucy;	U+00443
&fcy;	U+00444
&khcy;	U+00445
&tscy;	U+00446
&chcy;	U+00447
&shcy;	U+00448
&shchcy;	U+00449
&hardcy;	U+0044A
&ycy;	U+0044B
&softcy;	U+0044C
&ecy;	U+0044D
&yucy;	U+0044E
&yacy;	U+0044F
&iocy;	U+00451
&djcy;	U+00452
&gjcy;	U+00453
&jukcy;	U+00454
&dscy;	U+00455
&iukcy;	U+00456
&yicy;	U+00457
&jsercy;	U+00458
&ljcy;	U+00459
&njcy;	U+0045A
&tshcy;	U+0045B
&kjcy;	U+0045C
&ubrcy;	U+0045E
&dzcy;	U+0045F
&ensp;	U+02002
&emsp;	U+02003
&emsp13;	U+02004
&emsp14;	U+02005
&numsp;	U+02007
&puncsp;	U+02008
&ThinSpace;	U+02009
&hairsp;	U+0200A
&ZeroWidthSpace;	U+0200B
&zwnj;	U+0200C
&zwj;	U+0200D
&lrm;	U+0200E
&rlm;	U+0200F
&hyphen;	U+02010
&ndash;	U+02013
&mdash;	U+02014
&horbar;	U+02015
&Verbar;	U+02016
&OpenCurlyQuote;	U+02018
&rsquo;	U+02019
&sbquo;	U+0201A
&OpenCurlyDoubleQuote;	U+0201C
&rdquo;	U+0201D
&bdquo;	U+0201E
&dagger;	U+02020
&Dagger;	U+02021
&bull;	U+02022
&nldr;	U+02025
&hellip;	U+02026
&permil;	U+02030
&pertenk;	U+02031
&prime;	U+02032
&Prime;	U+02033
&tprime;	U+02034
&backprime;	U+02035
&lsaquo;	U+02039
&rsaquo;	U+0203A
&oline;	U+0203E
&caret;	U+02041
&hybull;	U+02043
&frasl;	U+02044
&bsemi;	U+0204F
&qprime;	U+02057
&MediumSpace;	U+0205F
&NoBreak;	U+02060
&af;	U+02061
&InvisibleTimes;	U+02062
&ic;	U+02063
&euro;	U+020AC
&TripleDot;	U+020DB
&DotDot;	U+020DC
&complexes;	U+02102
&incare;	U+02105
&gscr;	U+0210A
&HilbertSpace;	U+0210B
&Hfr;	U+0210C
&Hopf;	U+0210D
&planckh;	U+0210E
&planck;	U+0210F
&imagline;	U+02110
&Ifr;	U+02111
&lagran;	U+02112
&ell;	U+02113
&naturals;	U+02115
&numero;	U+02116
&copysr;	U+02117
&wp;	U+02118
&primes;	U+02119
&rationals;	U+0211A
&realine;	U+0211B
&Rfr;	U+0211C
&Ropf;	U+0211D
&rx;	U+0211E
&trade;	U+02122
&Zopf;	U+02124
&mho;	U+02127
&Zfr;	U+02128
&iiota;	U+02129
&Bscr;	U+0212C
&Cfr;	U+0212D
&escr;	U+0212F
&expectation;	U+02130
&Fouriertrf;	U+02131
&Mellintrf;	U+02133
&orderof;	U+02134
&aleph;	U+02135
&beth;	U+02136
&gimel;	U+02137
&daleth;	U+02138
&CapitalDifferentialD;	U+02145
&DifferentialD;	U+02146
&exponentiale;	U+02147
&ImaginaryI;	U+02148
&frac13;	U+02153
&frac23;	U+02154
&frac15;	U+02155
&frac25;	U+02156
&frac35;	U+02157
&frac45;	U+02158
&frac16;	U+02159
&frac56;	U+0215A
&frac18;	U+0215B
&frac38;	U+0215C
&frac58;	U+0215D
&frac78;	U+0215E
&larr;	U+02190
&uarr;	U+02191
&srarr;	U+02192
&darr;	U+02193
&harr;	U+02194
&UpDownArrow;	U+02195
&nwarrow;	U+02196
&UpperRightArrow;	U+02197
&LowerRightArrow;	U+02198
&swarr;	U+02199
&nleftarrow;	U+0219A
&nrarr;	U+0219B
&rarrw;	U+0219D
&Larr;	U+0219E
&Uarr;	U+0219F
&twoheadrightarrow;	U+021A0
&Darr;	U+021A1
&larrtl;	U+021A2
&rarrtl;	U+021A3
&LeftTeeArrow;	U+021A4
&UpTeeArrow;	U+021A5
&map;	U+021A6
&DownTeeArrow;	U+021A7
&larrhk;	U+021A9
&rarrhk;	U+021AA
&larrlp;	U+021AB
&looparrowright;	U+021AC
&harrw;	U+021AD
&nleftrightarrow;	U+021AE
&Lsh;	U+021B0
&rsh;	U+021B1
&ldsh;	U+021B2
&rdsh;	U+021B3
&crarr;	U+021B5
&curvearrowleft;	U+021B6
&curarr;	U+021B7
&olarr;	U+021BA
&orarr;	U+021BB
&leftharpoonup;	U+021BC
&leftharpoondown;	U+021BD
&RightUpVector;	U+021BE
&uharl;	U+021BF
&rharu;	U+021C0
&rhard;	U+021C1
&RightDownVector;	U+021C2
&dharl;	U+021C3
&rightleftarrows;	U+021C4
&udarr;	U+021C5
&lrarr;	U+021C6
&llarr;	U+021C7
&upuparrows;	U+021C8
&rrarr;	U+021C9
&downdownarrows;	U+021CA
&leftrightharpoons;	U+021CB
&rightleftharpoons;	U+021CC
&nLeftarrow;	U+021CD
&nhArr;	U+021CE
&nrArr;	U+021CF
&DoubleLeftArrow;	U+021D0
&DoubleUpArrow;	U+021D1
&Implies;	U+021D2
&Downarrow;	U+021D3
&hArr;	U+021D4
&Updownarrow;	U+021D5
&nwArr;	U+021D6
&neArr;	U+021D7
&seArr;	U+021D8
&swArr;	U+021D9
&lAarr;	U+021DA
&rAarr;	U+021DB
&zigrarr;	U+021DD
&LeftArrowBar;	U+021E4
&RightArrowBar;	U+021E5
&DownArrowUpArrow;	U+021F5
&loarr;	U+021FD
&roarr;	U+021FE
&hoarr;	U+021FF
&forall;	U+02200
&comp;	U+02201
&part;	U+02202
&Exists;	U+02203
&nexist;	U+02204
&empty;	U+02205
&nabla;	U+02207
&isinv;	U+02208
&notin;	U+02209
&ReverseElement;	U+0220B
&notniva;	U+0220C
&prod;	U+0220F
&Coproduct;	U+02210
&sum;	U+02211
&minus;	U+02212
&MinusPlus;	U+02213
&plusdo;	U+02214
&ssetmn;	U+02216
&lowast;	U+02217
&compfn;	U+02218
&Sqrt;	U+0221A
&prop;	U+0221D
&infin;	U+0221E
&angrt;	U+0221F
&angle;	U+02220
&angmsd;	U+02221
&angsph;	U+02222
&mid;	U+02223
&nshortmid;	U+02224
&shortparallel;	U+02225
&nparallel;	U+02226
&and;	U+02227
&or;	U+02228
&cap;	U+02229
&cup;	U+0222A
&Integral;	U+0222B
&Int;	U+0222C
&tint;	U+0222D
&ContourIntegral;	U+0222E
&DoubleContourIntegral;	U+0222F
&Cconint;	U+02230
&cwint;	U+02231
&cwconint;	U+02232
&awconint;	U+02233
&there4;	U+02234
&Because;	U+02235
&ratio;	U+02236
&Colon;	U+02237
&minusd;	U+02238
&mDDot;	U+0223A
&homtht;	U+0223B
&sim;	U+0223C
&bsim;	U+0223D
&ac;	U+0223E
&acd;	U+0223F
&wr;	U+02240
&NotTilde;	U+02241
&esim;	U+02242
&simeq;	U+02243
&nsime;	U+02244
&TildeFullEqual;	U+02245
&simne;	U+02246
&ncong;	U+02247
&approx;	U+02248
&napprox;	U+02249
&ape;	U+0224A
&apid;	U+0224B
&bcong;	U+0224C
&CupCap;	U+0224D
&bump;	U+0224E
&HumpEqual;	U+0224F
&esdot;	U+02250
&doteqdot;	U+02251
&fallingdotseq;	U+02252
&risingdotseq;	U+02253
&coloneq;	U+02254
&eqcolon;	U+02255
&ecir;	U+02256
&circeq;	U+02257
&wedgeq;	U+02259
&veeeq;	U+0225A
&triangleq;	U+0225C
&equest;	U+0225F
&NotEqual;	U+02260
&Congruent;	U+02261
&NotCongruent;	U+02262
&leq;	U+02264
&ge;	U+02265
&lE;	U+02266
&geqq;	U+02267
&lneqq;	U+02268
&gneqq;	U+02269
&ll;	U+0226A
&gg;	U+0226B
&between;	U+0226C
&NotCupCap;	U+0226D
&NotLess;	U+0226E
&ngtr;	U+0226F
&NotLessEqual;	U+02270
&ngeq;	U+02271
&LessTilde;	U+02272
&GreaterTilde;	U+02273
&nlsim;	U+02274
&ngsim;	U+02275
&lessgtr;	U+02276
&gl;	U+02277
&ntlg;	U+02278
&NotGreaterLess;	U+02279
&prec;	U+0227A
&succ;	U+0227B
&PrecedesSlantEqual;	U+0227C
&succcurlyeq;	U+0227D
&precsim;	U+0227E
&SucceedsTilde;	U+0227F
&npr;	U+02280
&NotSucceeds;	U+02281
&sub;	U+02282
&sup;	U+02283
&nsub;	U+02284
&nsup;	U+02285
&SubsetEqual;	U+02286
&supe;	U+02287
&NotSubsetEqual;	U+02288
&NotSupersetEqual;	U+02289
&subsetneq;	U+0228A
&supsetneq;	U+0228B
&cupdot;	U+0228D
&UnionPlus;	U+0228E
&sqsub;	U+0228F
&sqsupset;	U+02290
&SquareSubsetEqual;	U+02291
&SquareSupersetEqual;	U+02292
&sqcap;	U+02293
&sqcup;	U+02294
&CirclePlus;	U+02295
&ominus;	U+02296
&CircleTimes;	U+02297
&osol;	U+02298
&CircleDot;	U+02299
&ocir;	U+0229A
&oast;	U+0229B
&odash;	U+0229D
&boxplus;	U+0229E
&boxminus;	U+0229F
&timesb;	U+022A0
&sdotb;	U+022A1
&vdash;	U+022A2
&dashv;	U+022A3
&DownTee;	U+022A4
&perp;	U+022A5
&models;	U+022A7
&DoubleRightTee;	U+022A8
&Vdash;	U+022A9
&Vvdash;	U+022AA
&VDash;	U+022AB
&nvdash;	U+022AC
&nvDash;	U+022AD
&nVdash;	U+022AE
&nVDash;	U+022AF
&prurel;	U+022B0
&vartriangleleft;	U+022B2
&vrtri;	U+022B3
&LeftTriangleEqual;	U+022B4
&RightTriangleEqual;	U+022B5
&origof;	U+022B6
&imof;	U+022B7
&mumap;	U+022B8
&hercon;	U+022B9
&intcal;	U+022BA
&veebar;	U+022BB
&barvee;	U+022BD
&angrtvb;	U+022BE
&lrtri;	U+022BF
&xwedge;	U+022C0
&xvee;	U+022C1
&bigcap;	U+022C2
&bigcup;	U+022C3
&diamond;	U+022C4
&sdot;	U+022C5
&Star;	U+022C6
&divonx;	U+022C7
&bowtie;	U+022C8
&ltimes;	U+022C9
&rtimes;	U+022CA
&lthree;	U+022CB
&rthree;	U+022CC
&backsimeq;	U+022CD
&curlyvee;	U+022CE
&curlywedge;	U+022CF
&Sub;	U+022D0
&Supset;	U+022D1
&Cap;	U+022D2
&Cup;	U+022D3
&pitchfork;	U+022D4
&epar;	U+022D5
&lessdot;	U+022D6
&gtrdot;	U+022D7
&Ll;	U+022D8
&Gg;	U+022D9
&lesseqgtr;	U+022DA
&gtreqless;	U+022DB
&curlyeqprec;	U+022DE
&cuesc;	U+022DF
&NotPrecedesSlantEqual;	U+022E0
&NotSucceedsSlantEqual;	U+022E1
&NotSquareSubsetEqual;	U+022E2
&NotSquareSupersetEqual;	U+022E3
&lnsim;	U+022E6
&gnsim;	U+022E7
&precnsim;	U+022E8
&scnsim;	U+022E9
&nltri;	U+022EA
&ntriangleright;	U+022EB
&nltrie;	U+022EC
&NotRightTriangleEqual;	U+022ED
&vellip;	U+022EE
&ctdot;	U+022EF
&utdot;	U+022F0
&dtdot;	U+022F1
&disin;	U+022F2
&isinsv;	U+022F3
&isins;	U+022F4
&isindot;	U+022F5
&notinvc;	U+022F6
&notinvb;	U+022F7
&isinE;	U+022F9
&nisd;	U+022FA
&xnis;	U+022FB
&nis;	U+022FC
&notnivc;	U+022FD
&notnivb;	U+022FE
&barwed;	U+02305
&doublebarwedge;	U+02306
&lceil;	U+02308
&RightCeiling;	U+02309
&LeftFloor;	U+0230A
&RightFloor;	U+0230B
&drcrop;	U+0230C
&dlcrop;	U+0230D
&urcrop;	U+0230E
&ulcrop;	U+0230F
&bnot;	U+02310
&profline;	U+02312
&profsurf;	U+02313
&telrec;	U+02315
&target;	U+02316
&ulcorner;	U+0231C
&urcorner;	U+0231D
&llcorner;	U+0231E
&drcorn;	U+0231F
&frown;	U+02322
&smile;	U+02323
&cylcty;	U+0232D
&profalar;	U+0232E
&topbot;	U+02336
&ovbar;	U+0233D
&solbar;	U+0233F
&angzarr;	U+0237C
&lmoust;	U+023B0
&rmoust;	U+023B1
&OverBracket;	U+023B4
&bbrk;	U+023B5
&bbrktbrk;	U+023B6
&OverParenthesis;	U+023DC
&UnderParenthesis;	U+023DD
&OverBrace;	U+023DE
&UnderBrace;	U+023DF
&trpezium;	U+023E2
&elinters;	U+023E7
&blank;	U+02423
&oS;	U+024C8
&HorizontalLine;	U+02500
&boxv;	U+02502
&boxdr;	U+0250C
&boxdl;	U+02510
&boxur;	U+02514
&boxul;	U+02518
&boxvr;	U+0251C
&boxvl;	U+02524
&boxhd;	U+0252C
&boxhu;	U+02534
&boxvh;	U+0253C
&boxH;	U+02550
&boxV;	U+02551
&boxdR;	U+02552
&boxDr;	U+02553
&boxDR;	U+02554
&boxdL;	U+02555
&boxDl;	U+02556
&boxDL;	U+02557
&boxuR;	U+02558
&boxUr;	U+02559
&boxUR;	U+0255A
&boxuL;	U+0255B
&boxUl;	U+0255C
&boxUL;	U+0255D
&boxvR;	U+0255E
&boxVr;	U+0255F
&boxVR;	U+02560
&boxvL;	U+02561
&boxVl;	U+02562
&boxVL;	U+02563
&boxHd;	U+02564
&boxhD;	U+02565
&boxHD;	U+02566
&boxHu;	U+02567
&boxhU;	U+02568
&boxHU;	U+02569
&boxvH;	U+0256A
&boxVh;	U+0256B
&boxVH;	U+0256C
&uhblk;	U+02580
&lhblk;	U+02584
&block;	U+02588
&blk14;	U+02591
&blk12;	U+02592
&blk34;	U+02593
&Square;	U+025A1
&squarf;	U+025AA
&EmptyVerySmallSquare;	U+025AB
&rect;	U+025AD
&marker;	U+025AE
&fltns;	U+025B1
&bigtriangleup;	U+025B3
&blacktriangle;	U+025B4
&triangle;	U+025B5
&blacktriangleright;	U+025B8
&rtri;	U+025B9
&bigtriangledown;	U+025BD
&blacktriangledown;	U+025BE
&triangledown;	U+025BF
&blacktriangleleft;	U+025C2
&ltri;	U+025C3
&lozenge;	U+025CA
&cir;	U+025CB
&tridot;	U+025EC
&bigcirc;	U+025EF
&ultri;	U+025F8
&urtri;	U+025F9
&lltri;	U+025FA
&EmptySmallSquare;	U+025FB
&FilledSmallSquare;	U+025FC
&starf;	U+02605
&star;	U+02606
&phone;	U+0260E
&female;	U+02640
&male;	U+02642
&spadesuit;	U+02660
&clubs;	U+02663
&hearts;	U+02665
&diamondsuit;	U+02666
&sung;	U+0266A
&flat;	U+0266D
&natur;	U+0266E
&sharp;	U+0266F
&check;	U+02713
&cross;	U+02717
&maltese;	U+02720
&sext;	U+02736
&VerticalSeparator;	U+02758
&lbbrk;	U+02772
&rbbrk;	U+02773
&bsolhsub;	U+027C8
&suphsol;	U+027C9
&LeftDoubleBracket;	U+027E6
&RightDoubleBracket;	U+027E7
&langle;	U+027E8
&RightAngleBracket;	U+027E9
&Lang;	U+027EA
&Rang;	U+027EB
&loang;	U+027EC
&roang;	U+027ED
&longleftarrow;	U+027F5
&LongRightArrow;	U+027F6
&LongLeftRightArrow;	U+027F7
&xlArr;	U+027F8
&DoubleLongRightArrow;	U+027F9
&xhArr;	U+027FA
&xmap;	U+027FC
&dzigrarr;	U+027FF
&nvlArr;	U+02902
&nvrArr;	U+02903
&nvHarr;	U+02904
&Map;	U+02905
&lbarr;	U+0290C
&bkarow;	U+0290D
&lBarr;	U+0290E
&dbkarow;	U+0290F
&drbkarow;	U+02910
&DDotrahd;	U+02911
&UpArrowBar;	U+02912
&DownArrowBar;	U+02913
&Rarrtl;	U+02916
&latail;	U+02919
&ratail;	U+0291A
&lAtail;	U+0291B
&rAtail;	U+0291C
&larrfs;	U+0291D
&rarrfs;	U+0291E
&larrbfs;	U+0291F
&rarrbfs;	U+02920
&nwarhk;	U+02923
&nearhk;	U+02924
&searhk;	U+02925
&swarhk;	U+02926
&nwnear;	U+02927
&toea;	U+02928
&seswar;	U+02929
&swnwar;	U+0292A
&rarrc;	U+02933
&cudarrr;	U+02935
&ldca;	U+02936
&rdca;	U+02937
&cudarrl;	U+02938
&larrpl;	U+02939
&curarrm;	U+0293C
&cularrp;	U+0293D
&rarrpl;	U+02945
&harrcir;	U+02948
&Uarrocir;	U+02949
&lurdshar;	U+0294A
&ldrushar;	U+0294B
&LeftRightVector;	U+0294E
&RightUpDownVector;	U+0294F
&DownLeftRightVector;	U+02950
&LeftUpDownVector;	U+02951
&LeftVectorBar;	U+02952
&RightVectorBar;	U+02953
&RightUpVectorBar;	U+02954
&RightDownVectorBar;	U+02955
&DownLeftVectorBar;	U+02956
&DownRightVectorBar;	U+02957
&LeftUpVectorBar;	U+02958
&LeftDownVectorBar;	U+02959
&LeftTeeVector;	U+0295A
&RightTeeVector;	U+0295B
&RightUpTeeVector;	U+0295C
&RightDownTeeVector;	U+0295D
&DownLeftTeeVector;	U+0295E
&DownRightTeeVector;	U+0295F
&LeftUpTeeVector;	U+02960
&LeftDownTeeVector;	U+02961
&lHar;	U+02962
&uHar;	U+02963
&rHar;	U+02964
&dHar;	U+02965
&luruhar;	U+02966
&ldrdhar;	U+02967
&ruluhar;	U+02968
&rdldhar;	U+02969
&lharul;	U+0296A
&llhard;	U+0296B
&rharul;	U+0296C
&lrhard;	U+0296D
&udhar;	U+0296E
&ReverseUpEquilibrium;	U+0296F
&RoundImplies;	U+02970
&erarr;	U+02971
&simrarr;	U+02972
&larrsim;	U+02973
&rarrsim;	U+02974
&rarrap;	U+02975
&ltlarr;	U+02976
&gtrarr;	U+02978
&subrarr;	U+02979
&suplarr;	U+0297B
&lfisht;	U+0297C
&rfisht;	U+0297D
&ufisht;	U+0297E
&dfisht;	U+0297F
&lopar;	U+02985
&ropar;	U+02986
&lbrke;	U+0298B
&rbrke;	U+0298C
&lbrkslu;	U+0298D
&rbrksld;	U+0298E
&lbrksld;	U+0298F
&rbrkslu;	U+02990
&langd;	U+02991
&rangd;	U+02992
&lparlt;	U+02993
&rpargt;	U+02994
&gtlPar;	U+02995
&ltrPar;	U+02996
&vzigzag;	U+0299A
&vangrt;	U+0299C
&angrtvbd;	U+0299D
&ange;	U+029A4
&range;	U+029A5
&dwangle;	U+029A6
&uwangle;	U+029A7
&angmsdaa;	U+029A8
&angmsdab;	U+029A9
&angmsdac;	U+029AA
&angmsdad;	U+029AB
&angmsdae;	U+029AC
&angmsdaf;	U+029AD
&angmsdag;	U+029AE
&angmsdah;	U+029AF
&bemptyv;	U+029B0
&demptyv;	U+029B1
&cemptyv;	U+029B2
&raemptyv;	U+029B3
&laemptyv;	U+029B4
&ohbar;	U+029B5
&omid;	U+029B6
&opar;	U+029B7
&operp;	U+029B9
&olcross;	U+029BB
&odsold;	U+029BC
&olcir;	U+029BE
&ofcir;	U+029BF
&olt;	U+029C0
&ogt;	U+029C1
&cirscir;	U+029C2
&cirE;	U+029C3
&solb;	U+029C4
&bsolb;	U+029C5
&boxbox;	U+029C9
&trisb;	U+029CD
&rtriltri;	U+029CE
&LeftTriangleBar;	U+029CF
&RightTriangleBar;	U+029D0
&iinfin;	U+029DC
&infintie;	U+029DD
&nvinfin;	U+029DE
&eparsl;	U+029E3
&smeparsl;	U+029E4
&eqvparsl;	U+029E5
&lozf;	U+029EB
&RuleDelayed;	U+029F4
&dsol;	U+029F6
&xodot;	U+02A00
&bigoplus;	U+02A01
&bigotimes;	U+02A02
&biguplus;	U+02A04
&bigsqcup;	U+02A06
&iiiint;	U+02A0C
&fpartint;	U+02A0D
&cirfnint;	U+02A10
&awint;	U+02A11
&rppolint;	U+02A12
&scpolint;	U+02A13
&npolint;	U+02A14
&pointint;	U+02A15
&quatint;	U+02A16
&intlarhk;	U+02A17
&pluscir;	U+02A22
&plusacir;	U+02A23
&simplus;	U+02A24
&plusdu;	U+02A25
&plussim;	U+02A26
&plustwo;	U+02A27
&mcomma;	U+02A29
&minusdu;	U+02A2A
&loplus;	U+02A2D
&roplus;	U+02A2E
&Cross;	U+02A2F
&timesd;	U+02A30
&timesbar;	U+02A31
&smashp;	U+02A33
&lotimes;	U+02A34
&rotimes;	U+02A35
&otimesas;	U+02A36
&Otimes;	U+02A37
&odiv;	U+02A38
&triplus;	U+02A39
&triminus;	U+02A3A
&tritime;	U+02A3B
&iprod;	U+02A3C
&amalg;	U+02A3F
&capdot;	U+02A40
&ncup;	U+02A42
&ncap;	U+02A43
&capand;	U+02A44
&cupor;	U+02A45
&cupcap;	U+02A46
&capcup;	U+02A47
&cupbrcap;	U+02A48
&capbrcup;	U+02A49
&cupcup;	U+02A4A
&capcap;	U+02A4B
&ccups;	U+02A4C
&ccaps;	U+02A4D
&ccupssm;	U+02A50
&And;	U+02A53
&Or;	U+02A54
&andand;	U+02A55
&oror;	U+02A56
&orslope;	U+02A57
&andslope;	U+02A58
&andv;	U+02A5A
&orv;	U+02A5B
&andd;	U+02A5C
&ord;	U+02A5D
&wedbar;	U+02A5F
&sdote;	U+02A66
&simdot;	U+02A6A
&congdot;	U+02A6D
&easter;	U+02A6E
&apacir;	U+02A6F
&apE;	U+02A70
&eplus;	U+02A71
&pluse;	U+02A72
&Esim;	U+02A73
&Colone;	U+02A74
&Equal;	U+02A75
&ddotseq;	U+02A77
&equivDD;	U+02A78
&ltcir;	U+02A79
&gtcir;	U+02A7A
&ltquest;	U+02A7B
&gtquest;	U+02A7C
&les;	U+02A7D
&ges;	U+02A7E
&lesdot;	U+02A7F
&gesdot;	U+02A80
&lesdoto;	U+02A81
&gesdoto;	U+02A82
&lesdotor;	U+02A83
&gesdotol;	U+02A84
&lap;	U+02A85
&gap;	U+02A86
&lne;	U+02A87
&gne;	U+02A88
&lnap;	U+02A89
&gnap;	U+02A8A
&lesseqqgtr;	U+02A8B
&gEl;	U+02A8C
&lsime;	U+02A8D
&gsime;	U+02A8E
&lsimg;	U+02A8F
&gsiml;	U+02A90
&lgE;	U+02A91
&glE;	U+02A92
&lesges;	U+02A93
&gesles;	U+02A94
&els;	U+02A95
&egs;	U+02A96
&elsdot;	U+02A97
&egsdot;	U+02A98
&el;	U+02A99
&eg;	U+02A9A
&siml;	U+02A9D
&simg;	U+02A9E
&simlE;	U+02A9F
&simgE;	U+02AA0
&LessLess;	U+02AA1
&GreaterGreater;	U+02AA2
&glj;	U+02AA4
&gla;	U+02AA5
&ltcc;	U+02AA6
&gtcc;	U+02AA7
&lescc;	U+02AA8
&gescc;	U+02AA9
&smt;	U+02AAA
&lat;	U+02AAB
&smte;	U+02AAC
&late;	U+02AAD
&bumpE;	U+02AAE
&preceq;	U+02AAF
&SucceedsEqual;	U+02AB0
&prE;	U+02AB3
&scE;	U+02AB4
&precneqq;	U+02AB5
&scnE;	U+02AB6
&precapprox;	U+02AB7
&succapprox;	U+02AB8
&precnapprox;	U+02AB9
&succnapprox;	U+02ABA
&Pr;	U+02ABB
&Sc;	U+02ABC
&subdot;	U+02ABD
&supdot;	U+02ABE
&subplus;	U+02ABF
&supplus;	U+02AC0
&submult;	U+02AC1
&supmult;	U+02AC2
&subedot;	U+02AC3
&supedot;	U+02AC4
&subE;	U+02AC5
&supseteqq;	U+02AC6
&subsim;	U+02AC7
&supsim;	U+02AC8
&subsetneqq;	U+02ACB
&supnE;	U+02ACC
&csub;	U+02ACF
&csup;	U+02AD0
&csube;	U+02AD1
&csupe;	U+02AD2
&subsup;	U+02AD3
&supsub;	U+02AD4
&subsub;	U+02AD5
&supsup;	U+02AD6
&suphsub;	U+02AD7
&supdsub;	U+02AD8
&forkv;	U+02AD9
&topfork;	U+02ADA
&mlcp;	U+02ADB
&Dashv;	U+02AE4
&Vdashl;	U+02AE6
&Barv;	U+02AE7
&vBar;	U+02AE8
&vBarv;	U+02AE9
&Vbar;	U+02AEB
&Not;	U+02AEC
&bNot;	U+02AED
&rnmid;	U+02AEE
&cirmid;	U+02AEF
&midcir;	U+02AF0
&topcir;	U+02AF1
&nhpar;	U+02AF2
&parsim;	U+02AF3
&parsl;	U+02AFD
&fflig;	U+0FB00
&filig;	U+0FB01
&fllig;	U+0FB02
&ffilig;	U+0FB03
&ffllig;	U+0FB04
&Ascr;	U+1D49C
&Cscr;	U+1D49E
&Dscr;	U+1D49F
&Gscr;	U+1D4A2
&Jscr;	U+1D4A5
&Kscr;	U+1D4A6
&Nscr;	U+1D4A9
&Oscr;	U+1D4AA
&Pscr;	U+1D4AB
&Qscr;	U+1D4AC
&Sscr;	U+1D4AE
&Tscr;	U+1D4AF
&Uscr;	U+1D4B0
&Vscr;	U+1D4B1
&Wscr;	U+1D4B2
&Xscr;	U+1D4B3
&Yscr;	U+1D4B4
&Zscr;	U+1D4B5
&ascr;	U+1D4B6
&bscr;	U+1D4B7
&cscr;	U+1D4B8
&dscr;	U+1D4B9
&fscr;	U+1D4BB
&hscr;	U+1D4BD
&iscr;	U+1D4BE
&jscr;	U+1D4BF
&kscr;	U+1D4C0
&lscr;	U+1D4C1
&mscr;	U+1D4C2
&nscr;	U+1D4C3
&pscr;	U+1D4C5
&qscr;	U+1D4C6
&rscr;	U+1D4C7
&sscr;	U+1D4C8
&tscr;	U+1D4C9
&uscr;	U+1D4CA
&vscr;	U+1D4CB
&wscr;	U+1D4CC
&xscr;	U+1D4CD
&yscr;	U+1D4CE
&zscr;	U+1D4CF
&Afr;	U+1D504
&Bfr;	U+1D505
&Dfr;	U+1D507
&Efr;	U+1D508
&Ffr;	U+1D509
&Gfr;	U+1D50A
&Jfr;	U+1D50D
&Kfr;	U+1D50E
&Lfr;	U+1D50F
&Mfr;	U+1D510
&Nfr;	U+1D511
&Ofr;	U+1D512
&Pfr;	U+1D513
&Qfr;	U+1D514
&Sfr;	U+1D516
&Tfr;	U+1D517
&Ufr;	U+1D518
&Vfr;	U+1D519
&Wfr;	U+1D51A
&Xfr;	U+1D51B
&Yfr;	U+1D51C
&afr;	U+1D51E
&bfr;	U+1D51F
&cfr;	U+1D520
&dfr;	U+1D521
&efr;	U+1D522
&ffr;	U+1D523
&gfr;	U+1D524
&hfr;	U+1D525
&ifr;	U+1D526
&jfr;	U+1D527
&kfr;	U+1D528
&lfr;	U+1D529
&mfr;	U+1D52A
&nfr;	U+1D52B
&ofr;	U+1D52C
&pfr;	U+1D52D
&qfr;	U+1D52E
&rfr;	U+1D52F
&sfr;	U+1D530
&tfr;	U+1D531
&ufr;	U+1D532
&vfr;	U+1D533
&wfr;	U+1D534
&xfr;	U+1D535
&yfr;	U+1D536
&zfr;	U+1D537
&Aopf;	U+1D538
&Bopf;	U+1D539
&Dopf;	U+1D53B
&Eopf;	U+1D53C
&Fopf;	U+1D53D
&Gopf;	U+1D53E
&Iopf;	U+1D540
&Jopf;	U+1D541
&Kopf;	U+1D542
&Lopf;	U+1D543
&Mopf;	U+1D544
&Oopf;	U+1D546
&Sopf;	U+1D54A
&Topf;	U+1D54B
&Uopf;	U+1D54C
&Vopf;	U+1D54D
&Wopf;	U+1D54E
&Xopf;	U+1D54F
&Yopf;	U+1D550
&aopf;	U+1D552
&bopf;	U+1D553
&copf;	U+1D554
&dopf;	U+1D555
&eopf;	U+1D556
&fopf;	U+1D557
&gopf;	U+1D558
&hopf;	U+1D559
&iopf;	U+1D55A
&jopf;	U+1D55B
&kopf;	U+1D55C
&lopf;	U+1D55D
&mopf;	U+1D55E
&nopf;	U+1D55F
&oopf;	U+1D560
&popf;	U+1D561
&qopf;	U+1D562
&ropf;	U+1D563
&sopf;	U+1D564
&topf;	U+1D565
&uopf;	U+1D566
&vopf;	U+1D567
&wopf;	U+1D568
&xopf;	U+1D569
&yopf;	U+1D56A
&zopf;	U+1D56B
&nvlt;	U+0003C U+020D2
&bne;	U+0003D U+020E5
&nvgt;	U+0003E U+020D2
&fjlig;	U+00066 U+0006A
&ThickSpace;	U+0205F U+0200A
&nrarrw;	U+0219D U+00338
&npart;	U+02202 U+00338
&nang;	U+02220 U+020D2
&caps;	U+02229 U+0FE00
&cups;	U+0222A U+0FE00
&nvsim;	U+0223C U+020D2
&race;	U+0223D U+00331
&acE;	U+0223E U+00333
&nesim;	U+02242 U+00338
&napid;	U+0224B U+00338
&nvap;	U+0224D U+020D2
&nbump;	U+0224E U+00338
&nbumpe;	U+0224F U+00338
&nedot;	U+02250 U+00338
&bnequiv;	U+02261 U+020E5
&nvle;	U+02264 U+020D2
&nvge;	U+02265 U+020D2
&nlE;	U+02266 U+00338
&NotGreaterFullEqual;	U+02267 U+00338
&lvertneqq;	U+02268 U+0FE00
&gvertneqq;	U+02269 U+0FE00
&nLtv;	U+0226A U+00338
&nLt;	U+0226A U+020D2
&NotGreaterGreater;	U+0226B U+00338
&nGt;	U+0226B U+020D2
&NotSucceedsTilde;	U+0227F U+00338
&vnsub;	U+02282 U+020D2
&nsupset;	U+02283 U+020D2
&vsubne;	U+0228A U+0FE00
&vsupne;	U+0228B U+0FE00
&NotSquareSubset;	U+0228F U+00338
&NotSquareSuperset;	U+02290 U+00338
&sqcaps;	U+02293 U+0FE00
&sqcups;	U+02294 U+0FE00
&nvltrie;	U+022B4 U+020D2
&nvrtrie;	U+022B5 U+020D2
&nLl;	U+022D8 U+00338
&nGg;	U+022D9 U+00338
&lesg;	U+022DA U+0FE00
&gesl;	U+022DB U+0FE00
&notindot;	U+022F5 U+00338
&notinE;	U+022F9 U+00338
&nrarrc;	U+02933 U+00338
&NotLeftTriangleBar;	U+029CF U+00338
&NotRightTriangleBar;	U+029D0 U+00338
&ncongdot;	U+02A6D U+00338
&napE;	U+02A70 U+00338
&nles;	U+02A7D U+00338
&nges;	U+02A7E U+00338
&NotNestedLessLess;	U+02AA1 U+00338
&NotNestedGreaterGreater;	U+02AA2 U+00338
&smtes;	U+02AAC U+0FE00
&lates;	U+02AAD U+0FE00
&NotPrecedesEqual;	U+02AAF U+00338
&NotSucceedsEqual;	U+02AB0 U+00338
&nsubE;	U+02AC5 U+00338
&nsupseteqq;	U+02AC6 U+00338
&vsubnE;	U+02ACB U+0FE00
&varsupsetneqq;	U+02ACC U+0FE00
&parsl;︀	U+02AFD U+0FE00