#!/usr/bin/env python
# HFacer.py - regenerate the Scintilla.h and SciLexer.h files from the Scintilla.iface interface
# definition file.
# The header files are copied to a temporary file apart from the section between a /* ++Autogenerated*/
# comment and a /* --Autogenerated*/ comment which is generated by the printHFile and printLexHFile
# functions. After the temporary file is created, it is copied back to the original file name.

import sys
import os
import Face

def Contains(s,sub):
	return s.find(sub) != -1

def printLexHFile(f,out):
	for name in f.order:
		v = f.features[name]
		if v["FeatureType"] in ["val"]:
			if Contains(name, "SCE_") or Contains(name, "SCLEX_"):
				out.write("#define " + name + " " + v["Value"] + "\n")

def printHFile(f,out):
	for name in f.order:
		v = f.features[name]
		if v["Category"] != "Deprecated":
			if v["FeatureType"] in ["fun", "get", "set"]:
				featureDefineName = "SCI_" + name.upper()
				out.write("#define " + featureDefineName + " " + v["Value"] + "\n")
			elif v["FeatureType"] in ["evt"]:
				featureDefineName = "SCN_" + name.upper()
				out.write("#define " + featureDefineName + " " + v["Value"] + "\n")
			elif v["FeatureType"] in ["val"]:
				if not (Contains(name, "SCE_") or Contains(name, "SCLEX_")):
					out.write("#define " + name + " " + v["Value"] + "\n")

def CopyWithInsertion(input, output, genfn, definition):
	copying = 1
	for line in input.readlines():
		if copying:
			output.write(line)
		if Contains(line, "/* ++Autogenerated"):
			copying = 0
			genfn(definition, output)
		if Contains(line, "/* --Autogenerated"):
			copying = 1
			output.write(line)

def contents(filename):
	f = open(filename)
	t = f.read()
	f.close()
	return t

def Regenerate(filename, genfn, definition):
	inText = contents(filename)
	tempname = "HFacer.tmp"
	out = open(tempname,"w")
	hfile = open(filename)
	CopyWithInsertion(hfile, out, genfn, definition)
	out.close()
	hfile.close()
	outText = contents(tempname)
	if inText == outText:
		os.unlink(tempname)
	else:
		os.unlink(filename)
		os.rename(tempname, filename)

f = Face.Face()
try:
	f.ReadFromFile("Scintilla.iface")
	Regenerate("Scintilla.h", printHFile, f)
	Regenerate("SciLexer.h", printLexHFile, f)
	print("Maximum ID is %s" % max([x for x in f.values if int(x) < 3000]))
except:
	raise
