/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLAreaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLAreaElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLAreaElement)

/* Hash table */

static const HashTableValue JSHTMLAreaElementTableValues[16] =
{
    { "accessKey", DontDelete, (intptr_t)jsHTMLAreaElementAccessKey, (intptr_t)setJSHTMLAreaElementAccessKey },
    { "alt", DontDelete, (intptr_t)jsHTMLAreaElementAlt, (intptr_t)setJSHTMLAreaElementAlt },
    { "coords", DontDelete, (intptr_t)jsHTMLAreaElementCoords, (intptr_t)setJSHTMLAreaElementCoords },
    { "href", DontDelete, (intptr_t)jsHTMLAreaElementHref, (intptr_t)setJSHTMLAreaElementHref },
    { "noHref", DontDelete, (intptr_t)jsHTMLAreaElementNoHref, (intptr_t)setJSHTMLAreaElementNoHref },
    { "shape", DontDelete, (intptr_t)jsHTMLAreaElementShape, (intptr_t)setJSHTMLAreaElementShape },
    { "target", DontDelete, (intptr_t)jsHTMLAreaElementTarget, (intptr_t)setJSHTMLAreaElementTarget },
    { "hash", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementHash, (intptr_t)0 },
    { "host", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementHost, (intptr_t)0 },
    { "hostname", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementHostname, (intptr_t)0 },
    { "pathname", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementPathname, (intptr_t)0 },
    { "port", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementPort, (intptr_t)0 },
    { "protocol", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementProtocol, (intptr_t)0 },
    { "search", DontDelete|ReadOnly, (intptr_t)jsHTMLAreaElementSearch, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLAreaElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSHTMLAreaElementTableValues, 0 };
#else
    { 36, 31, JSHTMLAreaElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLAreaElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLAreaElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLAreaElementConstructorTableValues, 0 };
#endif

class JSHTMLAreaElementConstructor : public DOMObject {
public:
    JSHTMLAreaElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLAreaElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLAreaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLAreaElementConstructor::s_info = { "HTMLAreaElementConstructor", 0, &JSHTMLAreaElementConstructorTable, 0 };

bool JSHTMLAreaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElementConstructor, DOMObject>(exec, &JSHTMLAreaElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAreaElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAreaElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLAreaElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLAreaElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLAreaElementPrototype::s_info = { "HTMLAreaElementPrototype", 0, &JSHTMLAreaElementPrototypeTable, 0 };

JSObject* JSHTMLAreaElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLAreaElement>(exec);
}

const ClassInfo JSHTMLAreaElement::s_info = { "HTMLAreaElement", &JSHTMLElement::s_info, &JSHTMLAreaElementTable, 0 };

JSHTMLAreaElement::JSHTMLAreaElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLAreaElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLAreaElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLAreaElementPrototype(JSHTMLAreaElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLAreaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElement, Base>(exec, &JSHTMLAreaElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLAreaElementAccessKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->accessKey());
}

JSValuePtr jsHTMLAreaElementAlt(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->alt());
}

JSValuePtr jsHTMLAreaElementCoords(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->coords());
}

JSValuePtr jsHTMLAreaElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->href());
}

JSValuePtr jsHTMLAreaElementNoHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->noHref());
}

JSValuePtr jsHTMLAreaElementShape(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->shape());
}

JSValuePtr jsHTMLAreaElementTarget(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->target());
}

JSValuePtr jsHTMLAreaElementHash(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->hash());
}

JSValuePtr jsHTMLAreaElementHost(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->host());
}

JSValuePtr jsHTMLAreaElementHostname(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->hostname());
}

JSValuePtr jsHTMLAreaElementPathname(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->pathname());
}

JSValuePtr jsHTMLAreaElementPort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->port());
}

JSValuePtr jsHTMLAreaElementProtocol(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->protocol());
}

JSValuePtr jsHTMLAreaElementSearch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->search());
}

JSValuePtr jsHTMLAreaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLAreaElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLAreaElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLAreaElement, Base>(exec, propertyName, value, &JSHTMLAreaElementTable, this, slot);
}

void setJSHTMLAreaElementAccessKey(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setAccessKey(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAreaElementAlt(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setAlt(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAreaElementCoords(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setCoords(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAreaElementHref(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setHref(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAreaElementNoHref(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setNoHref(value->toBoolean(exec));
}

void setJSHTMLAreaElementShape(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setShape(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAreaElementTarget(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLAreaElement* imp = static_cast<HTMLAreaElement*>(static_cast<JSHTMLAreaElement*>(thisObject)->impl());
    imp->setTarget(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLAreaElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLAreaElementConstructor>(exec);
}


}
