/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLPreElement.h"

#include <wtf/GetPtr.h>

#include "HTMLPreElement.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLPreElement)

/* Hash table */

static const HashTableValue JSHTMLPreElementTableValues[4] =
{
    { "width", DontDelete, (intptr_t)jsHTMLPreElementWidth, (intptr_t)setJSHTMLPreElementWidth },
    { "wrap", DontDelete, (intptr_t)jsHTMLPreElementWrap, (intptr_t)setJSHTMLPreElementWrap },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLPreElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLPreElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSHTMLPreElementTableValues, 0 };
#else
    { 9, 7, JSHTMLPreElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLPreElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLPreElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLPreElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLPreElementConstructorTableValues, 0 };
#endif

class JSHTMLPreElementConstructor : public DOMObject {
public:
    JSHTMLPreElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLPreElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLPreElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLPreElementConstructor::s_info = { "HTMLPreElementConstructor", 0, &JSHTMLPreElementConstructorTable, 0 };

bool JSHTMLPreElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLPreElementConstructor, DOMObject>(exec, &JSHTMLPreElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLPreElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLPreElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLPreElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLPreElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLPreElementPrototype::s_info = { "HTMLPreElementPrototype", 0, &JSHTMLPreElementPrototypeTable, 0 };

JSObject* JSHTMLPreElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLPreElement>(exec);
}

const ClassInfo JSHTMLPreElement::s_info = { "HTMLPreElement", &JSHTMLElement::s_info, &JSHTMLPreElementTable, 0 };

JSHTMLPreElement::JSHTMLPreElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLPreElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLPreElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLPreElementPrototype(JSHTMLPreElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLPreElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLPreElement, Base>(exec, &JSHTMLPreElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLPreElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->width());
}

JSValuePtr jsHTMLPreElementWrap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->wrap());
}

JSValuePtr jsHTMLPreElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLPreElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLPreElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLPreElement, Base>(exec, propertyName, value, &JSHTMLPreElementTable, this, slot);
}

void setJSHTMLPreElementWidth(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(thisObject)->impl());
    imp->setWidth(value->toInt32(exec));
}

void setJSHTMLPreElementWrap(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(thisObject)->impl());
    imp->setWrap(value->toBoolean(exec));
}

JSValuePtr JSHTMLPreElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLPreElementConstructor>(exec);
}


}
