/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.server;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class ServerSelection {
    public static final String DEFAULT = "default";
    public static final String OTHER = "other";
    static final String COOKIE_PREFIX = "server.select";
    static final String COOKIE_REMEMBER = "remember";
    static final String COOKIE_URL = "url";
    static final String COOKIE_TYPE = "type";
    private String type = "default";
    private String location;
    private String defaultServerURL;
    private boolean remember;
    private String defaultServerContextName;

    public String getDefaultServerContextName() {
        return this.defaultServerContextName;
    }

    public void setDefaultServerContextName(String defaultWebapp) {
        this.defaultServerContextName = defaultWebapp;
    }

    public String getLocation() {
        String result = this.location;
        if (this.getType().equals(DEFAULT)) {
            result = this.defaultServerURL;
        }
        return result;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRemember() {
        return this.remember;
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    public String getDefaultServerURL() {
        return this.defaultServerURL;
    }

    public void setDefaultServerURL(String localURL) {
        this.defaultServerURL = localURL;
    }

    void setDefaultServerURL(HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        try {
            URL requestURL = new URL(request.getRequestURL().toString());
            String protocol = requestURL.getProtocol();
            result.append(protocol);
            result.append("://");
            result.append(request.getServerName());
            if (!(protocol.equals("http") && request.getLocalPort() == 80 || protocol.equals("https") && request.getLocalPort() == 443)) {
                result.append(":");
                result.append(request.getLocalPort());
            }
            result.append(this.getDefaultServerContextName());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.setDefaultServerURL(result.toString());
    }

    void setFromCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                String cookieValue = cookie.getValue();
                if (!cookieName.startsWith(COOKIE_PREFIX)) continue;
                if (cookieName.endsWith(COOKIE_URL)) {
                    this.setLocation(cookieValue);
                    continue;
                }
                if (cookieName.endsWith(COOKIE_TYPE)) {
                    this.setType(cookieValue);
                    continue;
                }
                if (!cookieName.endsWith(COOKIE_REMEMBER)) continue;
                this.setRemember(Boolean.parseBoolean(cookieValue));
            }
        }
    }
}

