.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH EVDEV __drivermansuffix__ __vendorversion__
.SH NAME
evdev \- Generic Linux input driver
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" devname \*q
.B  "  Driver \*qevdev\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
.BI "  Option \*qPath\*q     \*q" path \*q
.BI "  Option \*qEmulate3Buttons\*q     \*q" True \*q
.BI "  Option \*qEmulate3Timeout\*q     \*q" 50 \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B evdev 
is an __xservername__ input driver for Linux\'s generic event devices.  It
therefore supports all input devices that the kernel knows about, including
most mice and keyboards.
.PP
The 
.B evdev
driver can serve as both a pointer and a keyboard input device, and may be
used as both the core keyboard and the core pointer.  Multiple input devices
are supported by multiple instances of this driver, with one Load
directive for evdev in the Module section of your __xconfigfile__ for each
input device that will use this driver.
.PP
.SH SUPPORTED HARDWARE
In general, any input device that the kernel has a driver for can be accessed
through the 
.B evdev
driver.  See the Linux kernel documentation for a complete list.
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
The following driver 
.B Options
are supported:
.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
Specifies the device through which the device can be accessed.  This will 
generally be of the form \*q/dev/input/eventX\*q, where X is some integer.
The mapping from device node to hardware is system-dependent.  This option is
mandatory unless \*qPath\*q is given, and there is no default setting.
.TP 7
.BI "Option \*qPath\*q \*q" string \*q
Specifies the device through which the device can be accessed.  This will
generally be of the form \*q/dev/input/by-path/xyz\*q, where xyz includes the
name of the device. The mapping from device node to hardware is
system-dependent. This option has precedence over the \*qDevice\*q option but
one of \*qPath\*q or \*qDevice\*q must be given.
.TP 7
.BI "Option \*qEmulate3Buttons\*q \*q" boolean \*q
Enable/disable the emulation of the third (middle) mouse button for mice
which only have two physical buttons.  The third button is emulated by
pressing both buttons simultaneously.  Default: on, until a middle mouse
button event is registered.
.TP 7
.BI "Option \*qEmulate3Timeout\*q \*q" integer \*q
Sets the timeout (in milliseconds) that the driver waits before deciding
if two buttons where pressed "simultaneously" when 3 button emulation is
enabled.  Default: 50.
.TP 7
.BI "Option \*qReopenAttempts\*q \*q" integer \*q
Number of reopen attempts after a read error occurs on the device (e.g. after
waking up from suspend). In between each attempt is a 100ms wait. Default: 10.

.SH AUTHORS
Kristian Høgsberg.
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__),
README.mouse.
