/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_HOST_COPY_H
#define VN_PROTOCOL_RENDERER_HOST_COPY_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/*
 * These structs/unions/commands are not included
 *
 *   vkCopyMemoryToImage
 *   vkCopyImageToMemory
 */

/* struct VkCopyImageToImageInfo chain */

static inline void *
vn_decode_VkCopyImageToImageInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyImageToImageInfo_self_temp(struct vn_cs_decoder *dec, VkCopyImageToImageInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkImage_lookup(dec, &val->srcImage);
    vn_decode_VkImageLayout(dec, &val->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &val->dstImage);
    vn_decode_VkImageLayout(dec, &val->dstImageLayout);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pRegions), iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageCopy2_temp(dec, &((VkImageCopy2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkCopyImageToImageInfo_temp(struct vn_cs_decoder *dec, VkCopyImageToImageInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyImageToImageInfo_pnext_temp(dec);
    vn_decode_VkCopyImageToImageInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyImageToImageInfo_handle_self(VkCopyImageToImageInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkImage_handle(&val->srcImage);
    /* skip val->srcImageLayout */
    vn_replace_VkImage_handle(&val->dstImage);
    /* skip val->dstImageLayout */
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkImageCopy2_handle(&((VkImageCopy2 *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkCopyImageToImageInfo_handle(VkCopyImageToImageInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO:
            vn_replace_VkCopyImageToImageInfo_handle_self((VkCopyImageToImageInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkHostImageLayoutTransitionInfo chain */

static inline void *
vn_decode_VkHostImageLayoutTransitionInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkHostImageLayoutTransitionInfo_self_temp(struct vn_cs_decoder *dec, VkHostImageLayoutTransitionInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_VkImageLayout(dec, &val->oldLayout);
    vn_decode_VkImageLayout(dec, &val->newLayout);
    vn_decode_VkImageSubresourceRange_temp(dec, &val->subresourceRange);
}

static inline void
vn_decode_VkHostImageLayoutTransitionInfo_temp(struct vn_cs_decoder *dec, VkHostImageLayoutTransitionInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkHostImageLayoutTransitionInfo_pnext_temp(dec);
    vn_decode_VkHostImageLayoutTransitionInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkHostImageLayoutTransitionInfo_handle_self(VkHostImageLayoutTransitionInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->image);
    /* skip val->oldLayout */
    /* skip val->newLayout */
    vn_replace_VkImageSubresourceRange_handle(&val->subresourceRange);
}

static inline void
vn_replace_VkHostImageLayoutTransitionInfo_handle(VkHostImageLayoutTransitionInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO:
            vn_replace_VkHostImageLayoutTransitionInfo_handle_self((VkHostImageLayoutTransitionInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyImageToMemoryInfoMESA chain */

static inline void *
vn_decode_VkCopyImageToMemoryInfoMESA_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyImageToMemoryInfoMESA_self_temp(struct vn_cs_decoder *dec, VkCopyImageToMemoryInfoMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkImage_lookup(dec, &val->srcImage);
    vn_decode_VkImageLayout(dec, &val->srcImageLayout);
    vn_decode_uint32_t(dec, &val->memoryRowLength);
    vn_decode_uint32_t(dec, &val->memoryImageHeight);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->imageSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->imageOffset);
    vn_decode_VkExtent3D_temp(dec, &val->imageExtent);
}

static inline void
vn_decode_VkCopyImageToMemoryInfoMESA_temp(struct vn_cs_decoder *dec, VkCopyImageToMemoryInfoMESA *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_MESA)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyImageToMemoryInfoMESA_pnext_temp(dec);
    vn_decode_VkCopyImageToMemoryInfoMESA_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyImageToMemoryInfoMESA_handle_self(VkCopyImageToMemoryInfoMESA *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkImage_handle(&val->srcImage);
    /* skip val->srcImageLayout */
    /* skip val->memoryRowLength */
    /* skip val->memoryImageHeight */
    vn_replace_VkImageSubresourceLayers_handle(&val->imageSubresource);
    vn_replace_VkOffset3D_handle(&val->imageOffset);
    vn_replace_VkExtent3D_handle(&val->imageExtent);
}

static inline void
vn_replace_VkCopyImageToMemoryInfoMESA_handle(VkCopyImageToMemoryInfoMESA *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_MESA:
            vn_replace_VkCopyImageToMemoryInfoMESA_handle_self((VkCopyImageToMemoryInfoMESA *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkMemoryToImageCopyMESA chain */

static inline void *
vn_decode_VkMemoryToImageCopyMESA_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkMemoryToImageCopyMESA_self_temp(struct vn_cs_decoder *dec, VkMemoryToImageCopyMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_size_t(dec, &val->dataSize);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->dataSize);
        val->pData = vn_cs_decoder_get_blob_storage(dec, array_size);
        if (!val->pData) return;
        vn_decode_blob_array(dec, (void *)val->pData, array_size);
    } else {
        vn_decode_array_size(dec, val->dataSize);
        val->pData = NULL;
    }
    vn_decode_uint32_t(dec, &val->memoryRowLength);
    vn_decode_uint32_t(dec, &val->memoryImageHeight);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->imageSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->imageOffset);
    vn_decode_VkExtent3D_temp(dec, &val->imageExtent);
}

static inline void
vn_decode_VkMemoryToImageCopyMESA_temp(struct vn_cs_decoder *dec, VkMemoryToImageCopyMESA *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_MESA)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkMemoryToImageCopyMESA_pnext_temp(dec);
    vn_decode_VkMemoryToImageCopyMESA_self_temp(dec, val);
}

static inline void
vn_replace_VkMemoryToImageCopyMESA_handle_self(VkMemoryToImageCopyMESA *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dataSize */
    /* skip val->pData */
    /* skip val->memoryRowLength */
    /* skip val->memoryImageHeight */
    vn_replace_VkImageSubresourceLayers_handle(&val->imageSubresource);
    vn_replace_VkOffset3D_handle(&val->imageOffset);
    vn_replace_VkExtent3D_handle(&val->imageExtent);
}

static inline void
vn_replace_VkMemoryToImageCopyMESA_handle(VkMemoryToImageCopyMESA *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_MESA:
            vn_replace_VkMemoryToImageCopyMESA_handle_self((VkMemoryToImageCopyMESA *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyMemoryToImageInfoMESA chain */

static inline void *
vn_decode_VkCopyMemoryToImageInfoMESA_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyMemoryToImageInfoMESA_self_temp(struct vn_cs_decoder *dec, VkCopyMemoryToImageInfoMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkImage_lookup(dec, &val->dstImage);
    vn_decode_VkImageLayout(dec, &val->dstImageLayout);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pRegions), iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryToImageCopyMESA_temp(dec, &((VkMemoryToImageCopyMESA *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkCopyMemoryToImageInfoMESA_temp(struct vn_cs_decoder *dec, VkCopyMemoryToImageInfoMESA *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_MESA)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyMemoryToImageInfoMESA_pnext_temp(dec);
    vn_decode_VkCopyMemoryToImageInfoMESA_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyMemoryToImageInfoMESA_handle_self(VkCopyMemoryToImageInfoMESA *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkImage_handle(&val->dstImage);
    /* skip val->dstImageLayout */
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkMemoryToImageCopyMESA_handle(&((VkMemoryToImageCopyMESA *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkCopyMemoryToImageInfoMESA_handle(VkCopyMemoryToImageInfoMESA *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_MESA:
            vn_replace_VkCopyMemoryToImageInfoMESA_handle_self((VkCopyMemoryToImageInfoMESA *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCopyImageToImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCopyImageToImage *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyImageToImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyImageToImageInfo));
        if (!args->pCopyImageToImageInfo) return;
        vn_decode_VkCopyImageToImageInfo_temp(dec, (VkCopyImageToImageInfo *)args->pCopyImageToImageInfo);
    } else {
        args->pCopyImageToImageInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCopyImageToImage_args_handle(struct vn_command_vkCopyImageToImage *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCopyImageToImageInfo)
        vn_replace_VkCopyImageToImageInfo_handle((VkCopyImageToImageInfo *)args->pCopyImageToImageInfo);
}

static inline void vn_encode_vkCopyImageToImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCopyImageToImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCopyImageToImage_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCopyImageToImageInfo */
}

static inline void vn_decode_vkTransitionImageLayout_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkTransitionImageLayout *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->transitionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->transitionCount);
        args->pTransitions = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pTransitions), iter_count);
        if (!args->pTransitions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkHostImageLayoutTransitionInfo_temp(dec, &((VkHostImageLayoutTransitionInfo *)args->pTransitions)[i]);
    } else {
        vn_decode_array_size(dec, args->transitionCount);
        args->pTransitions = NULL;
    }
}

static inline void vn_replace_vkTransitionImageLayout_args_handle(struct vn_command_vkTransitionImageLayout *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->transitionCount */
    if (args->pTransitions) {
       for (uint32_t i = 0; i < args->transitionCount; i++)
            vn_replace_VkHostImageLayoutTransitionInfo_handle(&((VkHostImageLayoutTransitionInfo *)args->pTransitions)[i]);
    }
}

static inline void vn_encode_vkTransitionImageLayout_reply(struct vn_cs_encoder *enc, const struct vn_command_vkTransitionImageLayout *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkTransitionImageLayout_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->transitionCount */
    /* skip args->pTransitions */
}

static inline void vn_decode_vkCopyImageToMemoryMESA_args_temp(struct vn_cs_decoder *dec, struct vn_cs_encoder *enc, struct vn_command_vkCopyImageToMemoryMESA *args)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToMemoryMESA_EXT;
    size_t offset = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    offset += vn_sizeof_VkResult(&ret);
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyImageToMemoryInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyImageToMemoryInfo));
        if (!args->pCopyImageToMemoryInfo) return;
        vn_decode_VkCopyImageToMemoryInfoMESA_temp(dec, (VkCopyImageToMemoryInfoMESA *)args->pCopyImageToMemoryInfo);
    } else {
        args->pCopyImageToMemoryInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    vn_decode_size_t(dec, &args->dataSize);
    if (vn_peek_array_size(dec)) {
        offset += vn_sizeof_array_size(args->dataSize);
        const size_t array_size = vn_decode_array_size(dec, args->dataSize);
        args->pData = vn_cs_encoder_get_blob_storage(enc, offset, array_size);
        if (!args->pData) return;
        offset += vn_sizeof_blob_array(args->pData, array_size);
    } else {
        vn_decode_array_size(dec, args->dataSize);
        args->pData = NULL;
    }
}

static inline void vn_replace_vkCopyImageToMemoryMESA_args_handle(struct vn_command_vkCopyImageToMemoryMESA *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCopyImageToMemoryInfo)
        vn_replace_VkCopyImageToMemoryInfoMESA_handle((VkCopyImageToMemoryInfoMESA *)args->pCopyImageToMemoryInfo);
    /* skip args->dataSize */
    /* skip args->pData */
}

static inline void vn_encode_vkCopyImageToMemoryMESA_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCopyImageToMemoryMESA *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCopyImageToMemoryMESA_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCopyImageToMemoryInfo */
    /* skip args->dataSize */
    if (args->pData) {
        vn_encode_array_size(enc, args->dataSize);
        vn_encode_blob_array(enc, args->pData, args->dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkCopyMemoryToImageMESA_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCopyMemoryToImageMESA *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyMemoryToImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyMemoryToImageInfo));
        if (!args->pCopyMemoryToImageInfo) return;
        vn_decode_VkCopyMemoryToImageInfoMESA_temp(dec, (VkCopyMemoryToImageInfoMESA *)args->pCopyMemoryToImageInfo);
    } else {
        args->pCopyMemoryToImageInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCopyMemoryToImageMESA_args_handle(struct vn_command_vkCopyMemoryToImageMESA *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCopyMemoryToImageInfo)
        vn_replace_VkCopyMemoryToImageInfoMESA_handle((VkCopyMemoryToImageInfoMESA *)args->pCopyMemoryToImageInfo);
}

static inline void vn_encode_vkCopyMemoryToImageMESA_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCopyMemoryToImageMESA *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCopyMemoryToImageMESA_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCopyMemoryToImageInfo */
}

static inline void vn_dispatch_vkCopyImageToImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCopyImageToImage args;

    if (!ctx->dispatch_vkCopyImageToImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCopyImageToImage_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCopyImageToImage(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCopyImageToImage returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCopyImageToImage_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkTransitionImageLayout(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkTransitionImageLayout args;

    if (!ctx->dispatch_vkTransitionImageLayout) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkTransitionImageLayout_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkTransitionImageLayout(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkTransitionImageLayout returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkTransitionImageLayout_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCopyImageToMemoryMESA(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCopyImageToMemoryMESA args;

    if (!ctx->dispatch_vkCopyImageToMemoryMESA) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) {
        if (!vn_cs_encoder_acquire(ctx->encoder))
           return;
    }

    vn_decode_vkCopyImageToMemoryMESA_args_temp(ctx->decoder, ctx->encoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCopyImageToMemoryMESA(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCopyImageToMemoryMESA returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        vn_encode_vkCopyImageToMemoryMESA_reply(ctx->encoder, &args);
        vn_cs_encoder_release(ctx->encoder);
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCopyMemoryToImageMESA(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCopyMemoryToImageMESA args;

    if (!ctx->dispatch_vkCopyMemoryToImageMESA) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCopyMemoryToImageMESA_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCopyMemoryToImageMESA(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCopyMemoryToImageMESA returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCopyMemoryToImageMESA_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_HOST_COPY_H */
