/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2004-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl>
 *
 */



/*!
    \page lcmaps_verify_proxy.mod Verification plugin plugin
 
    \section posixsynopsis SYNOPSIS
    \b lcmaps_verify_proxy.mod
 
    \section posixdesc DESCRIPTION
 
The Verify Proxy module will verify the validity of the proxy (with its chain) or any other X.509 certificate chain that has been used in the LCMAPS framework.
The module will report to the LCMAPS framework the validity of the chain.

 
*/



#ifndef PROXYLIFETIME_H
   #define PROXYLIFETIME_H


/*****************************************************************************
                            Include header files
******************************************************************************/
#include "lcmaps_verify_proxy_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <pwd.h>
#include <openssl/x509.h>
#include <openssl/x509v3.h>
#include <openssl/x509_vfy.h>
#include <openssl/asn1.h>
#include <openssl/bio.h>
#include <time.h>


#include "_verify_x509.h"

#include <lcmaps/lcmaps_modules.h>
#include <lcmaps/lcmaps_arguments.h>

#include <lcmaps/lcmaps_cred_data.h>
#include <lcmaps/lcmaps_vo_data.h>
#include <lcmaps/lcmaps_types.h>


/******************************************************************************
                                Definitions
******************************************************************************/

#define LEAF_PROXY      2000
#define INNER_PROXY     3000
#define MYPROXY_PROXY   4000
#define UNDEFINED_PROXY 4000
#define PLUGIN_RUN      0
#define PLUGIN_VERIFY   1



// What do we want to do with this time presentation?
#define GMT               1
#define LOCAL             2
#define LEAVE_TIME_ITS_OK 3

struct TProxyLevelTTL
{
   int    level;
   time_t ttl;
   struct TProxyLevelTTL * next;
};

 
/******************************************************************************
                          Module specific prototypes
******************************************************************************/

int verifyProxyTTL (STACK_OF(X509) *chain, int depth);
int verifyProxyLifeTime (struct TProxyLevelTTL * plt, STACK_OF(X509) *chain, int depth);
int verifyVOMSLifeTime (struct TProxyLevelTTL * plt, lcmaps_vomsdata_t * lcmaps_vomsdata);

/* static struct tm * ASN1_TIME_2_time_t(ASN1_TIME *); */
char * sttm_2_char (const struct tm *);
struct tm * createTime (const time_t t);


int strnclean (char **s, int bufsize);
int strclean (char **s);


time_t asn1TimeToTimeT(char *asn1time);
time_t char2time_t (char * datetime);
time_t ttl_char2time_t (char * datetime);

void print_lcmaps_vomsdata_local(lcmaps_vomsdata_t * lcmaps_vomsdata);


void Push_New_Entry (struct TProxyLevelTTL ** p, int level, time_t ttl);
time_t Search_TTL_By_Level (struct TProxyLevelTTL * p, int level);
void FreeProxyLevelTTL (struct TProxyLevelTTL ** p);
void Print_TTL_By_Level (struct TProxyLevelTTL * p);
int timeIsInBetween (time_t this, time_t t1, time_t t2);


/******************************************************************************
                       Define module specific variables
******************************************************************************/

/* static struct TProxyLevelTTL * plt = NULL; */
/* static struct TProxyLevelTTL * vplt = NULL; */
/*
static char * certdir = NULL;
static int    allow_limited = 0;
static int    only_post_verify = 0;
static struct TProxyLevelTTL * plt = NULL;
static struct TProxyLevelTTL * vplt = NULL;
static int    discard_private_key_absence = 0;
*/

/*****************************************************************************/


#endif /* PROXYLIFETIME_H */
