/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;

public class NodeKindTest
extends NodeTest {
    public static final NodeKindTest DOCUMENT = new NodeKindTest(9);
    public static final NodeKindTest ELEMENT = new NodeKindTest(1);
    public static final NodeKindTest ATTRIBUTE = new NodeKindTest(2);
    public static final NodeKindTest TEXT = new NodeKindTest(3);
    public static final NodeKindTest COMMENT = new NodeKindTest(8);
    public static final NodeKindTest PROCESSING_INSTRUCTION = new NodeKindTest(7);
    public static final NodeKindTest NAMESPACE = new NodeKindTest(13);
    private int kind;

    private NodeKindTest(int n) {
        this.kind = n;
        switch (n) {
            case 9: {
                this.originalText = "/";
                break;
            }
            case 1: {
                this.originalText = "element()";
                break;
            }
            case 2: {
                this.originalText = "attribute()";
                break;
            }
            case 8: {
                this.originalText = "comment()";
                break;
            }
            case 3: {
                this.originalText = "text()";
                break;
            }
            case 7: {
                this.originalText = "processing-instruction()";
                break;
            }
            case 13: {
                this.originalText = "namespace()";
            }
        }
    }

    public static NodeTest makeNodeKindTest(int n) {
        switch (n) {
            case 9: {
                return DOCUMENT;
            }
            case 1: {
                return ELEMENT;
            }
            case 2: {
                return ATTRIBUTE;
            }
            case 8: {
                return COMMENT;
            }
            case 3: {
                return TEXT;
            }
            case 7: {
                return PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NAMESPACE;
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown node kind in NodeKindTest");
    }

    public boolean matches(int n, int n2, int n3) {
        return this.kind == n;
    }

    public final double getDefaultPriority() {
        return -0.5;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public boolean allowsTextNodes() {
        return this.kind == 3;
    }

    public String toString() {
        return this.originalText;
    }
}

