/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi;

import alt.jiapi.Instrumentor;
import alt.jiapi.JiapiException;
import alt.jiapi.Rule;
import alt.jiapi.Runtime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Category;

public class InstrumentationDescriptor {
    private static Category log = Runtime.getLogCategory(InstrumentationDescriptor.class);
    private boolean debugLoader = false;
    private List instrumentors = Collections.synchronizedList(new ArrayList());
    private Set inclusionRules = new TreeSet(Collections.reverseOrder());
    private Set exclusionRules = new TreeSet(Collections.reverseOrder());

    public void addInstrumentor(Instrumentor instrumentor) {
        this.instrumentors.add(instrumentor);
    }

    public List getInstrumentors() {
        return this.instrumentors;
    }

    public void addInclusionRule(String rule) throws JiapiException {
        this.inclusionRules.add(new Rule(rule));
    }

    public Set getInclusionsRules() {
        return this.inclusionRules;
    }

    public void addExclusionRule(String rule) throws JiapiException {
        this.exclusionRules.add(new Rule(rule));
    }

    public Set getExclusionsRules() {
        return this.exclusionRules;
    }

    public boolean match(String className) {
        log.debug((Object)("Matching rules to " + className));
        Rule exclusionRule = null;
        Rule inclusionRule = null;
        for (Rule rule : this.inclusionRules) {
            if (!rule.match(className)) continue;
            inclusionRule = rule;
            break;
        }
        if (inclusionRule == null) {
            log.debug((Object)("Excluding: " + className + " cause: no match"));
            return false;
        }
        for (Rule rule : this.exclusionRules) {
            if (!rule.match(className)) continue;
            exclusionRule = rule;
            break;
        }
        if (exclusionRule == null) {
            log.debug((Object)("Including: " + className + " cause: " + inclusionRule + ", no exclusion rule"));
            return true;
        }
        if (inclusionRule.isMoreSignificant(exclusionRule)) {
            log.debug((Object)("Including: " + className + " cause:\n  include " + inclusionRule + " is more significant than " + exclusionRule));
            return true;
        }
        log.debug((Object)("Excluding: " + className + " cause:\n  excluding " + exclusionRule + " is more significant than " + inclusionRule));
        return false;
    }

    public String toString() {
        return this.inclusionRules.toString() + ", " + this.exclusionRules.toString();
    }
}

