/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import jbet.ClassFileException;
import jbet.ConstantPool;
import jbet.Lexer;
import jbet.LineWriter;
import jbet.Util;

class InnerClassInfo
implements Cloneable {
    boolean good;
    int accessFlags;
    String inner = null;
    String outer = null;
    String simpleName = null;
    int innerIndex;
    int outerIndex;
    int simpleIndex = 0;

    InnerClassInfo() {
    }

    public InnerClassInfo(Lexer lexer) {
        lexer.push(8);
        if (!lexer.match((int)258).text.equals(".inner")) {
            lexer.unexpected(lexer.justread());
        }
        lexer.state = 9;
        this.inner = lexer.parse_name();
        this.outer = lexer.parse_name();
        this.simpleName = lexer.parse_name();
        this.accessFlags = lexer.parse_flags(1567);
        lexer.term();
        lexer.pop();
    }

    public InnerClassInfo(String i, String o, String s, int a) {
        this.inner = i;
        this.outer = o;
        this.simpleName = s;
        this.accessFlags = a;
    }

    public InnerClassInfo(String i, int a) {
        this.inner = i;
        this.outer = i.substring(0, i.lastIndexOf(36));
        this.simpleName = i.substring(i.lastIndexOf(36) + 1);
        this.accessFlags = a;
    }

    public InnerClassInfo(DataInputStream dataIn, ConstantPool constantPool) throws IOException, ClassFileException {
        this.innerIndex = dataIn.readUnsignedShort();
        this.outerIndex = dataIn.readUnsignedShort();
        this.simpleIndex = dataIn.readUnsignedShort();
        if (this.innerIndex != 0) {
            this.inner = constantPool.cpClassAt(this.innerIndex).string();
        }
        if (this.outerIndex != 0) {
            this.outer = constantPool.cpClassAt(this.outerIndex).string();
        }
        if (this.simpleIndex != 0) {
            this.simpleName = constantPool.utf8At(this.simpleIndex);
        }
        this.accessFlags = dataIn.readUnsignedShort();
    }

    InnerClassInfo dup() {
        InnerClassInfo innerClassInfo = this;
        try {
            InnerClassInfo innerClassInfo2 = (InnerClassInfo)innerClassInfo.clone();
            return innerClassInfo2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void relocate(Hashtable hashtable) {
        String string;
        String string2;
        InnerClassInfo innerClassInfo = this;
        Hashtable hashtable2 = hashtable;
        InnerClassInfo innerClassInfo2 = innerClassInfo;
        String string3 = innerClassInfo2.inner;
        Hashtable hashtable3 = hashtable2;
        innerClassInfo2.inner = string2 = Util.relocate(string3, hashtable3);
        String string4 = innerClassInfo2.outer;
        innerClassInfo2.outer = string = Util.relocate(string4, hashtable3);
    }

    public void disassemble(LineWriter lineWriter, String string) {
        InnerClassInfo innerClassInfo = this;
        LineWriter lineWriter2 = lineWriter;
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append(string2);
        StringBuffer stringBuffer3 = stringBuffer2.append(".inner ");
        InnerClassInfo innerClassInfo2 = innerClassInfo;
        String string3 = innerClassInfo2.inner;
        StringBuffer stringBuffer4 = stringBuffer3.append(string3);
        StringBuffer stringBuffer5 = stringBuffer4.append(" ");
        String string4 = innerClassInfo2.outer;
        StringBuffer stringBuffer6 = stringBuffer5.append(string4);
        StringBuffer stringBuffer7 = stringBuffer6.append(" ");
        String string5 = innerClassInfo2.simpleName;
        StringBuffer stringBuffer8 = stringBuffer7.append(string5);
        StringBuffer stringBuffer9 = stringBuffer8.append(" ");
        int n = innerClassInfo2.accessFlags;
        String string6 = Util.flags2str(n, true);
        StringBuffer stringBuffer10 = stringBuffer9.append(string6);
        String string7 = stringBuffer10.toString();
        lineWriter2.println(string7);
    }

    void writeFile(DataOutputStream dataOutputStream) throws IOException {
        DataOutputStream dataOutputStream2;
        InnerClassInfo innerClassInfo;
        InnerClassInfo innerClassInfo2 = innerClassInfo = this;
        InnerClassInfo innerClassInfo3 = innerClassInfo;
        InnerClassInfo innerClassInfo4 = innerClassInfo;
        InnerClassInfo innerClassInfo5 = innerClassInfo;
        DataOutputStream dataOutputStream3 = dataOutputStream2 = dataOutputStream;
        DataOutputStream dataOutputStream4 = dataOutputStream2;
        DataOutputStream dataOutputStream5 = dataOutputStream2;
        DataOutputStream dataOutputStream6 = dataOutputStream2;
        int n = innerClassInfo2.inner == null ? 0 : innerClassInfo.innerIndex;
        dataOutputStream5.writeShort(n);
        int n2 = innerClassInfo4.outer == null ? 0 : innerClassInfo5.outerIndex;
        dataOutputStream2.writeShort(n2);
        InnerClassInfo innerClassInfo6 = innerClassInfo3;
        int n3 = innerClassInfo6.simpleIndex;
        DataOutputStream dataOutputStream7 = dataOutputStream6;
        dataOutputStream7.writeShort(n3);
        int n4 = innerClassInfo6.accessFlags & 0x61F;
        dataOutputStream7.writeShort(n4);
    }

    void resolveConstants(ConstantPool constantPool) {
        ConstantPool constantPool2;
        InnerClassInfo innerClassInfo;
        InnerClassInfo innerClassInfo2 = innerClassInfo = this;
        InnerClassInfo innerClassInfo3 = innerClassInfo;
        InnerClassInfo innerClassInfo4 = innerClassInfo;
        InnerClassInfo innerClassInfo5 = innerClassInfo;
        InnerClassInfo innerClassInfo6 = innerClassInfo;
        ConstantPool constantPool3 = constantPool2 = constantPool;
        ConstantPool constantPool4 = constantPool2;
        if (innerClassInfo2.inner != null) {
            int n;
            InnerClassInfo innerClassInfo7 = innerClassInfo3;
            String string = innerClassInfo7.inner;
            innerClassInfo7.innerIndex = n = constantPool2.internClass(string);
        }
        if (innerClassInfo6.outer != null) {
            int n;
            InnerClassInfo innerClassInfo8 = innerClassInfo;
            String string = innerClassInfo8.outer;
            innerClassInfo8.outerIndex = n = constantPool4.internClass(string);
        }
        if (innerClassInfo4.simpleName != null) {
            int n;
            InnerClassInfo innerClassInfo9 = innerClassInfo5;
            String string = innerClassInfo9.simpleName;
            innerClassInfo9.simpleIndex = n = constantPool3.internUtf8(string);
        }
    }

    String recString() {
        InnerClassInfo innerClassInfo = this;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("inner(");
        InnerClassInfo innerClassInfo2 = innerClassInfo;
        String string = innerClassInfo2.inner;
        StringBuffer stringBuffer3 = stringBuffer2.append(string);
        StringBuffer stringBuffer4 = stringBuffer3.append(") outer(");
        String string2 = innerClassInfo2.outer;
        StringBuffer stringBuffer5 = stringBuffer4.append(string2);
        StringBuffer stringBuffer6 = stringBuffer5.append(") simple(");
        String string3 = innerClassInfo2.simpleName;
        StringBuffer stringBuffer7 = stringBuffer6.append(string3);
        StringBuffer stringBuffer8 = stringBuffer7.append(")");
        return stringBuffer8.toString();
    }
}

