#if   !defined(__ABSTRACTSTRING_HPP)
#define  __ABSTRACTSTRING_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if !defined IN_COMMON_HPP
   #error AbstractString.hpp is included by common.hpp only.
#endif

namespace corelinux
{
   DECLARE_CLASS( AbstractString );

   /**
   AbstractString is a temporary base abstraction. It is the goal
   of the library to support adaptors for other string implementations
   while providing a consistent interface.
   */

   class AbstractString
   {
   public:

      //
      // Constructors and destructors
      //

                           // Default Constructor

                           AbstractString( void );

                           // Copy constructor
            
                           AbstractString( AbstractStringCref );

                           //  Destructor

      virtual              ~AbstractString( void );

      //
      // Operators
      //

               // Assignment operator

               AbstractStringRef operator=( AbstractStringCref ) ;

               // Equality check

               bool              operator==( AbstractStringCref ) const;


      //
      // Accessors
      //

               // Indicates mbcs or unicode based character count

      virtual  Byte     getElementByteCount( void ) const = 0;

               // Can it be casted to std::string ?

      virtual  bool     supportsStandardInterface( void ) const = 0;

               // Is a mbcs based string?

      virtual  bool     isUtf8( void ) const = 0;

               // Is a 16 bit character string?

      virtual  bool     isUcs2( void ) const = 0;

               // Is a 32 bit character string (Linux wchar_t)

      virtual  bool     isUcs4( void ) const = 0;

      //
      // Mutators
      //

      //
      // Factory methods and conversions
      //

               // Default clone method

      virtual  AbstractStringPtr clone( void ) const
                        throw ( Exception ) = 0;

               // Clone ones self to a Utf8 implementation

      virtual  AbstractStringPtr cloneUtf8( void ) const 
                        throw ( Exception ) = 0;

               // Clone ones self to a Ucs2 implementation

      virtual  AbstractStringPtr cloneUcs2( void ) const 
                        throw ( Exception ) = 0;

               // Clone ones self to a Ucs4 implementation

      virtual  AbstractStringPtr cloneUcs4( void ) const 
                        throw ( Exception ) = 0;

   };
}


#endif

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

