/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.Benchmark;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.model.Measurement;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public final class ArbitraryMeasurementWorker
implements Worker {
    private static final Ticker defaultTicker = new Ticker(){

        public long read() {
            return System.nanoTime();
        }
    };
    private final Ticker ticker;

    public ArbitraryMeasurementWorker() {
        this(defaultTicker);
    }

    public ArbitraryMeasurementWorker(Ticker ticker) {
        this.ticker = ticker;
    }

    @Override
    public Collection<Measurement> measure(Benchmark benchmark, String methodName, Map<String, String> optionsMap, WorkerEventLog log) throws Exception {
        Options options = new Options(optionsMap);
        Method method = benchmark.getClass().getDeclaredMethod(methodName, new Class[0]);
        ArbitraryMeasurement annotation = method.getAnnotation(ArbitraryMeasurement.class);
        String unit = annotation.units();
        String description = annotation.description();
        log.notifyMeasurementPhaseStarting();
        if (options.gcBeforeEach) {
            Util.forceGc();
        }
        log.notifyMeasurementStarting();
        double measured = (Double)method.invoke((Object)benchmark, new Object[0]);
        Measurement m = new Measurement();
        m.value = measured;
        m.weight = 1.0;
        m.unit = unit;
        m.description = description;
        log.notifyMeasurementEnding(m.value);
        return ImmutableList.of((Object)m);
    }

    private static class Options {
        final boolean gcBeforeEach;

        Options(Map<String, String> options) {
            this.gcBeforeEach = Boolean.parseBoolean(options.get("gcBeforeEach"));
        }
    }
}

