/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class PrintStream
extends FilterOutputStream {
    private boolean autoFlush = false;
    private boolean trouble = false;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing = false;

    public PrintStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    private PrintStream(boolean bl, OutputStream outputStream) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("Null output stream");
        }
        this.autoFlush = bl;
    }

    private void init(OutputStreamWriter outputStreamWriter) {
        this.charOut = outputStreamWriter;
        this.textOut = new BufferedWriter(outputStreamWriter);
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        this(bl, outputStream);
        this.init(new OutputStreamWriter(this));
    }

    public PrintStream(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        this(bl, outputStream);
        this.init(new OutputStreamWriter((OutputStream)this, string));
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException iOException) {
                this.trouble = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.textOut.close();
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.trouble = true;
                }
                this.textOut = null;
                this.charOut = null;
                this.out = null;
            }
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.out.write(n);
                if (n == 10 && this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.out.write(byArray, n, n2);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] cArray) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.write(cArray);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    for (int i = 0; i < cArray.length; ++i) {
                        if (cArray[i] != '\n') continue;
                        this.out.flush();
                    }
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.write(string);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush && string.indexOf(10) >= 0) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.newLine();
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(bl);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(n);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(cArray);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(string);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(object);
            this.newLine();
        }
    }
}

