#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
TAR=../libjuniversalchardet-java_$VERSION.orig.tar.gz
DIR=juniversalchardet

tar -zxf $3
rm $3
GZIP=--best tar -c -z -f $TAR \
 --exclude '.classpath' \
 --exclude '.project' \
 --exclude 'c' \
 --exclude 'c/*' \
 --exclude 'swig' \
 --exclude 'swig/*' \
 $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
