/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file FortranViewNodeAttributes.h
    \brief Definition of FortranViewNode Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:27 2013
*/
   

#ifndef FortranViewNodeAttributes_H
#define FortranViewNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "PreviewVisitor.h"
#include "Transformation.h"
#include "MagnifierVisitor.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class FortranViewNodeAttributes 
{
public:
//  --  constructor
    FortranViewNodeAttributes();
    
//  --  destructor
    virtual ~FortranViewNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const FortranViewNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string vertical_;
	string horizontal_;
	double top_;
	double bottom_;
	double left_;
	double bottom_internal_;
	double left_internal_;
	double right_;
	double width_;
	double height_;
	double height_internal_;
	double width_internal_;
	auto_ptr<Colour> background_;
	bool frame_;
	auto_ptr<Colour> frame_colour_;
	LineStyle frame_line_style_;
	int frame_thickness_;
	double vertical_axis_with_;
	double horizontal_axis_height_;
	string overlay_;
	auto_ptr<Transformation> transformation_;
	string json_;
	bool title_;
	auto_ptr<NoPreviewVisitor> preview_;
	auto_ptr<NoMagnifierVisitor> magnify_;

private:
  
	friend ostream& operator<<(ostream& s,const FortranViewNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
