/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file LabelPlottingAttributes.h
    \brief Definition of LabelPlotting Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:20 2013
*/
   

#ifndef LabelPlottingAttributes_H
#define LabelPlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class LabelPlottingAttributes 
{
public:
//  --  constructor
    LabelPlottingAttributes();
    
//  --  destructor
    virtual ~LabelPlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const LabelPlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string quality_;
	auto_ptr<Colour> colour_;
	double height_;
	int latFrequency_;
	int lonFrequency_;
	bool left_;
	bool right_;
	bool top_;
	bool bottom_;

private:
  
	friend ostream& operator<<(ostream& s,const LabelPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
