# 不再推荐使用的功能

本文中列出的功能不再推荐使用。它们在 Commander 未来的主要版本（major version）中可能被移除。为保证后向兼容，这些功能目前还可以使用，但它们不应被用在新代码中。

## .option() 方法的正则表达式参数

`.option()`方法可以接受一个正则表达式作为第三个参数，以规定可以接受的选项参数值。

```js
program.option('-c,--coffee <type>', 'coffee', /short-white|long-black/);
```

该功能从 Commander v3 的文档中被移除。自 Commander v7 起，该功能不再推荐使用。

新的写法是使用`Option`对象的`.choices()`方法，或者使用自定义选项处理函数。

## noHelp

此选项曾被用作传入`.command()`方法，以在内建的帮助信息中隐藏该命令：

```js
program.command('example', 'examnple command', { noHelp: true });
```

在 Commander v5.1 中，该选项被更名为`hidden`。自 Commander v7 起`noHelp`不再推荐使用。

## 默认导入的全局 Command 对象

Commander 的默认导入曾是一个全局的`Command`对象。

```js
const program = require('commander');
```

自 Commander v5 后，全局`Command`对象作为 `program`被导出。或者也可以导入`Command`对象。

```js
const { program } = require('commander');
// 或者
const { Command } = require('commander');
comnst program = new Command()
```

- 此功能在 Commander v5 的文档中被移除。
- 自 Commander v7 起不再推荐使用。
- 在 Commander v8 的 TypeScript 定义文件中被移除。

## .help() 与 .outputHelp() 的回调函数参数

这两个方法曾允许传入一个回调函数，以在展示前处理帮助信息。

```js
program.outputHelp((text) => {
  return colors.red(text);
});
```

新的写法是直接通过调用`.helpInformation()`来获取帮助文本。

```js
console.error(colors.red(program.helpInformation()));
```

原功能自 Commander v7 起不再推荐使用。

## .on('--help')

此功能曾被用作在内建的帮助信息后输出自定义的帮助信息。自 Commander v3.0.0 起，如果有自定义的帮助选项，则此方法使用该自定义的帮助选项。

```js
program.on('--help', function() {
  console.log('')
  console.log('Examples:');
  console.log('  $ custom-help --help');
  console.log('  $ custom-help -h');
});
```

替代的方法是使用`.addHelpText()`：

```js
program.addHelpText('after', `
Examples:
  $ custom-help --help
  $ custom-help -h`
);
```

原功能自 Commander v7 起不再推荐使用。

## cmd.description(cmdDescription, argDescriptions)

此功能曾用来为命令参数添加描述信息。

```js
program
  .command('price <book>')
  .description('show price of book', {
    book: 'ISBN number for book'
  });
```

新的写法是使用`.argument()`方法。

```js
program
  .command('price')
  .description('show price of book')
  .argument('<book>', 'ISBN number for book');
```

原功能自 Commander v8 起不再推荐使用。

## InvalidOptionArgumentError

此类曾被用来在自定义选项处理中抛出错误，以显示错误信息。

```js
function myParseInt(value, dummyPrevious) {
  // parseInt 参数为字符串和进制数
  const parsedValue = parseInt(value, 10);
  if (isNaN(parsedValue)) {
    throw new commander.InvalidOptionArgumentError('Not a number.');
  }
  return parsedValue;
}
```

替代的类是`InvalidArgumentError`，它也可用于自定义命令参数处理。

```js
function myParseInt(value, dummyPrevious) {
  // parseInt 参数为字符串和进制数
  const parsedValue = parseInt(value, 10);
  if (isNaN(parsedValue)) {
    throw new commander.InvalidArgumentError('Not a number.');
  }
  return parsedValue;
}
```

原功能自 Commander v8 起不再推荐使用。
