# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Activity(Model):
    """Definition of the activity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Gets or sets the id of the resource.
    :type id: str
    :ivar name: Gets the name of the activity.
    :vartype name: str
    :param definition: Gets or sets the user name of the activity.
    :type definition: str
    :param parameter_sets: Gets or sets the parameter sets of the activity.
    :type parameter_sets:
     list[~azure.mgmt.automation.models.ActivityParameterSet]
    :param output_types: Gets or sets the output types of the activity.
    :type output_types: list[~azure.mgmt.automation.models.ActivityOutputType]
    :param creation_time: Gets or sets the creation time.
    :type creation_time: datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'definition': {'key': 'properties.definition', 'type': 'str'},
        'parameter_sets': {'key': 'properties.parameterSets', 'type': '[ActivityParameterSet]'},
        'output_types': {'key': 'properties.outputTypes', 'type': '[ActivityOutputType]'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Activity, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.definition = kwargs.get('definition', None)
        self.parameter_sets = kwargs.get('parameter_sets', None)
        self.output_types = kwargs.get('output_types', None)
        self.creation_time = kwargs.get('creation_time', None)
        self.last_modified_time = kwargs.get('last_modified_time', None)
        self.description = kwargs.get('description', None)
