# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class DeadlineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The types of deadlines supported by ScheduledActions."""

    UNKNOWN = "Unknown"
    """Default value of Unknown."""
    INITIATE_AT = "InitiateAt"
    """Initiate the operation at the given deadline."""
    COMPLETE_BY = "CompleteBy"
    """Complete the operation by the given deadline."""


class OperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Values that define the states of operations in Scheduled Actions."""

    UNKNOWN = "Unknown"
    """The default value for the operation state enum"""
    PENDING_SCHEDULING = "PendingScheduling"
    """Operations that are pending scheduling"""
    SCHEDULED = "Scheduled"
    """Operations that have been scheduled"""
    PENDING_EXECUTION = "PendingExecution"
    """Operations that are waiting to be executed"""
    EXECUTING = "Executing"
    """Operations that are in the process of being executed"""
    SUCCEEDED = "Succeeded"
    """Operations that suceeded"""
    FAILED = "Failed"
    """Operations that have failed"""
    CANCELLED = "Cancelled"
    """Operations that have been Cancelled by the user"""
    BLOCKED = "Blocked"
    """Operations that are blocked"""


class OptimizationPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The preferences customers can select to optimize their requests to ScheduledActions."""

    COST = "Cost"
    """Optimize while considering cost savings"""
    AVAILABILITY = "Availability"
    """Optimize while considering availability of resources"""
    COST_AVAILABILITY_BALANCED = "CostAvailabilityBalanced"
    """Optimize while considering a balance of cost and availability"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ResourceOperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of operation types that can be performed on resources using ScheduledActions."""

    UNKNOWN = "Unknown"
    """The default value for this enum type"""
    START = "Start"
    """Start operations on the resources"""
    DEALLOCATE = "Deallocate"
    """Deallocate operations on the resources"""
    HIBERNATE = "Hibernate"
    """Hibernate operations on the resources"""
