# License: BSD-3-Clause
# Copyright the MNE-Python contributors.
from pathlib import Path

from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.common.exceptions import WebDriverException


def generate_contrib_avatars(app, config):
    """Render a template webpage with avatars generated by JS and a GitHub API call."""
    root = Path(app.srcdir)
    infile = root / "sphinxext" / "_avatar_template.html"
    outfile = root / "_templates" / "avatars.html"
    try:
        options = webdriver.ChromeOptions()
        options.add_argument("--headless=new")
        driver = webdriver.Chrome(options=options)
    except WebDriverException:
        options = webdriver.FirefoxOptions()
        options.add_argument("--headless=new")
        driver = webdriver.Firefox(options=options)
    driver.get(f"file://{infile}")
    wait = WebDriverWait(driver, 20)
    wait.until(lambda d: d.find_element(by=By.ID, value="contributor-avatars"))
    body = driver.find_element(by=By.TAG_NAME, value="body").get_attribute("innerHTML")
    with open(outfile, "w") as fid:
        fid.write(body)
    driver.quit()


def setup(app):
    """Set up the Sphinx app."""
    app.connect("config-inited", generate_contrib_avatars)
    return
