/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Drop
implements Serializable {
    static final long serialVersionUID = 26653827678657381L;
    private final int cpu;
    private final Kind kind;
    private final long count;
    private final long total;
    private final String defaultMessage;

    public Drop(int dropCPU, String dropKindName, long dropCount, long totalDrops, String defaultDropMessage) {
        this.cpu = dropCPU;
        this.kind = Enum.valueOf(Kind.class, dropKindName);
        this.count = dropCount;
        this.total = totalDrops;
        this.defaultMessage = defaultDropMessage;
        this.validate();
    }

    private final void validate() {
        if (this.count < 0L) {
            throw new IllegalArgumentException("count is negative");
        }
        if (this.total < 0L) {
            throw new IllegalArgumentException("total is negative");
        }
        if (this.defaultMessage == null) {
            throw new NullPointerException("default message is null");
        }
    }

    public int getCPU() {
        return this.cpu;
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Drop.class.getName());
        buf.append("[cpu = ");
        buf.append(this.cpu);
        buf.append(", kind = ");
        buf.append((Object)this.kind);
        buf.append(", count = ");
        buf.append(this.count);
        buf.append(", total = ");
        buf.append(this.total);
        buf.append(", defaultMessage = ");
        buf.append(this.defaultMessage);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Drop.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"CPU", "kind", "count", "total", "defaultMessage"}){

                protected Expression instantiate(Object oldInstance, Encoder out) {
                    Drop drop = (Drop)oldInstance;
                    return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{drop.getCPU(), drop.getKind().name(), drop.getCount(), drop.getTotal(), drop.getDefaultMessage()});
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        PRINCIPAL("Principal buffer"),
        AGGREGATION("Aggregation"),
        DYNAMIC("Dynamic"),
        DYNRINSE("Dynamic (rinse)"),
        DYNDIRTY("Dynamic (dirty)"),
        SPEC("Speculation"),
        SPECBUSY("Speculation (busy)"),
        SPECUNAVAIL("Speculation (unavailable)"),
        STKSTROVERFLOW("Stack string table overflow"),
        DBLERROR("error in ERROR probe"),
        UNKNOWN("Unknown");

        private String s;

        private Kind(String displayString) {
            this.s = displayString;
        }

        public String toString() {
            return this.s;
        }
    }
}

