/*	$NetBSD: bcm2835_mboxreg.h,v 1.1 2012/08/20 07:45:24 skrll Exp $	*/

/*-
 * Copyright (c) 2012 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Nick Hudson
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BCM2835_MBOXREG_H_
#define	_BCM2835_MBOXREG_H_

/* mailbox 0 (from VC) and mailbox 1 (to VC) */
#define	BCM2835_MBOX_SIZE	0x80

#define	BCM2835_MBOX_READ	0x00
#define	BCM2835_MBOX_WRITE	0x00
#define	BCM2835_MBOX_POLL	0x10	/* read without popping the fifo */
#define	BCM2835_MBOX_ID		0x14	/* sender ID (bottom two bits) */
#define	BCM2835_MBOX_STATUS	0x18	/* status */
#define	 BCM2835_MBOX_STATUS_FULL	0x80000000
#define	 BCM2835_MBOX_STATUS_EMPTY	0x40000000
#define	 BCM2835_MBOX_STATUS_LEVEL	0x400000FF
#define	BCM2835_MBOX_CFG	0x1C	/* configuration */
#define	 BCM2835_MBOX_CFG_DATAIRQEN		0x00000001
#define	 BCM2835_MBOX_CFG_SPACEIRQEN		0x00000002
#define	 BCM2835_MBOX_CFG_EMPTYOPIRQEN		0x00000004
#define	 BCM2835_MBOX_CFG_MAILCLEAR		0x00000008
#define	 BCM2835_MBOX_CFG_DATAPENDING		0x00000010
#define	 BCM2835_MBOX_CFG_SPACEPENDING		0x00000020
#define	 BCM2835_MBOX_CFG_EMPTYOPPENDING	0x00000040
#define	 BCM2835_MBOX_CFG_ENOOWN		0x00000100
#define	 BCM2835_MBOX_CFG_EOVERFLOW		0x00000200
#define	 BCM2835_MBOX_CFG_EUNDERFLOW		0x00000400

#define	BCM2835_MBOX0_BASE	0x00
#define	BCM2835_MBOX1_BASE	0x20

#define	BCM2835_MBOX0_READ	(BCM2835_MBOX0_BASE + BCM2835_MBOX_READ)
#define	BCM2835_MBOX0_WRITE	(BCM2835_MBOX0_BASE + BCM2835_MBOX_WRITE)
#define	BCM2835_MBOX0_POLL	(BCM2835_MBOX0_BASE + BCM2835_MBOX_POLL)
#define	BCM2835_MBOX0_ID	(BCM2835_MBOX0_BASE + BCM2835_MBOX_ID)
#define	BCM2835_MBOX0_STATUS	(BCM2835_MBOX0_BASE + BCM2835_MBOX_STATUS)
#define	BCM2835_MBOX0_CFG	(BCM2835_MBOX0_BASE + BCM2835_MBOX_READ)

#define	BCM2835_MBOX1_READ	(BCM2835_MBOX1_BASE + BCM2835_MBOX_READ)
#define	BCM2835_MBOX1_WRITE	(BCM2835_MBOX1_BASE + BCM2835_MBOX_WRITE)
#define	BCM2835_MBOX1_POLL	(BCM2835_MBOX1_BASE + BCM2835_MBOX_POLL)
#define	BCM2835_MBOX1_ID	(BCM2835_MBOX1_BASE + BCM2835_MBOX_ID)
#define	BCM2835_MBOX1_STATUS	(BCM2835_MBOX1_BASE + BCM2835_MBOX_STATUS)
#define	BCM2835_MBOX1_CFG	(BCM2835_MBOX1_BASE + BCM2835_MBOX_READ)

#endif /* _BCM2835_MBOXREG_H_ */
