# $NetBSD: deptgt.mk,v 1.22 2025/01/10 23:00:38 rillig Exp $
#
# Tests for special targets like .BEGIN or .SUFFIXES in dependency
# declarations.

# TODO: Implementation

# Just in case anyone tries to compile several special targets in a single
# dependency line: That doesn't work, and make immediately rejects it.
# expect+1: warning: Extra target '.PHONY' ignored
.SUFFIXES .PHONY: .c.o

# The following lines demonstrate how 'targets' is set and reset during
# parsing of dependencies.  To see it in action, set breakpoints in:
#
#	ParseDependency		at the beginning
#	FinishDependencyGroup	at "targets = NULL"
#	Parse_File		at "Lst_Free(targets)"
#	Parse_File		at "targets = Lst_New()"
#	ParseLine_ShellCommand	at "targets == NULL"
#
# Keywords:
#	parse.c:targets

target1 target2: sources	# targets := [target1, target2]
	: command1		# targets == [target1, target2]
	: command2		# targets == [target1, target2]
VAR=value			# targets := NULL
# expect+1: Unassociated shell command ": command3		# parse error, since targets == NULL"
	: command3		# parse error, since targets == NULL

# In a dependency declaration, the list of targets can be empty.
# It doesn't matter whether the empty string is generated by an
# expression or whether it is just omitted.
.MAKEFLAGS: -dp
${:U}: empty-source
	: command for empty targets list
: empty-source
	: command for empty targets list
.MAKEFLAGS: -d0

# An expression based on an undefined variable is allowed on both sides of
# the dependency declaration.
.MAKEFLAGS: -dv
deptgt-${UNDEF}: depsrc-${UNDEF}
.MAKEFLAGS: -d0

# In a dependency declaration, the whole line is expanded before interpreting
# the line.
# expect+1: Unknown modifier "Z"
${:U:Z}:
# After expanding the line as a whole, each target is parsed but not
# evaluated, separately, in ParseDependencyTargetWord.
# expect+1: Unknown modifier "Z"
$${:U:Z}:

# expect+1: warning: Extra target 'ordinary' ignored
.END ordinary:

# expect+1: warning: Extra target (ordinary) ignored
.PATH ordinary:

# expect+1: warning: Special and mundane targets don't mix. Mundane ones ignored
ordinary .PATH:
