/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.assignment;

import com.projectlibre1.configuration.CircularDependencyException;
import com.projectlibre1.datatype.Duration;
import com.projectlibre1.datatype.Rate;
import com.projectlibre1.document.Document;
import com.projectlibre1.functor.IntervalConsumer;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.HasTimeDistributedData;
import com.projectlibre1.pm.assignment.contour.AbstractContour;
import com.projectlibre1.pm.assignment.contour.AbstractContourBucket;
import com.projectlibre1.pm.assignment.contour.ContourTypes;
import com.projectlibre1.pm.assignment.contour.PersonalContour;
import com.projectlibre1.pm.assignment.contour.StandardContour;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.calendar.InvalidCalendarIntersectionException;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.criticalpath.TaskSchedule;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.scheduling.Delayable;
import com.projectlibre1.pm.scheduling.DelayableImpl;
import com.projectlibre1.pm.scheduling.Schedule;
import com.projectlibre1.pm.scheduling.ScheduleInterval;
import com.projectlibre1.pm.scheduling.ScheduleUtil;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.time.MutableInterval;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.DateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;

public final class AssignmentDetail
implements Schedule,
HasCalendar,
Cloneable,
Serializable,
ContourTypes {
    static final long serialVersionUID = 867792734923243L;
    transient Rate rate = new Rate(1.0, 6);
    double percentComplete = 0.0;
    long duration = 0L;
    private int workContourType;
    private int costContourType;
    private transient AbstractContour workContour = StandardContour.FLAT_CONTOUR;
    private transient AbstractContour costContour = StandardContour.FLAT_CONTOUR;
    private WorkingCalendar actualExceptionsCalendar = null;
    private transient WorkingCalendar intersectionCalendar = null;
    private transient TaskSchedule taskSchedule = null;
    private transient Resource resource;
    private transient Task task;
    private transient Delayable delayable;
    private int requestDemandType = 0;
    private int costRateIndex = 0;
    private long overtimeWork = 0L;
    private WorkingCalendar baselineCalendar = null;
    private static short DEFAULT_VERSION = 1;
    private short version = DEFAULT_VERSION;

    @Override
    public double getPercentComplete() {
        return this.percentComplete;
    }

    @Override
    public void setPercentComplete(double d) {
        this.percentComplete = d;
        if (this.getTask() != null) {
            ((NormalTask)this.getTask()).adjustActualStartFromAssignments();
        }
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    void recalculateDuration() {
        this.duration = this.workContour.calcTotalBucketDuration(0L);
    }

    void setTaskSchedule(TaskSchedule taskSchedule) {
        this.taskSchedule = taskSchedule;
    }

    void replaceResourceAndUnits(double d, Resource resource) {
        this.resource = resource;
        this.setUnits(d);
    }

    AssignmentDetail(Task task, Resource resource, double d, int n, long l) {
        this.task = task;
        this.resource = resource;
        this.setUnits(d);
        this.requestDemandType = n;
        this.delayable = new DelayableImpl(l, 0L);
    }

    private AssignmentDetail() {
    }

    double getUnits() {
        return this.rate.getValue();
    }

    void setUnits(double d) {
        this.rate.setValue(d);
    }

    double calcOvertimeUnits() {
        long l = this.calcWorkingDuration();
        if (l == 0L) {
            return 0.0;
        }
        return (double)this.overtimeWork / (double)l;
    }

    void setOvertimeWork(long l) {
        this.overtimeWork = l;
    }

    long calcWork() {
        return (long)(this.getUnits() * (double)this.calcWorkingDuration());
    }

    public String toString() {
        return super.toString();
    }

    AbstractContour getWorkContour() {
        return this.workContour;
    }

    public void debugSetWorkContour(AbstractContour abstractContour) {
        this.workContour = abstractContour;
    }

    public long getDelay() {
        return this.delayable.getDelay();
    }

    void setDelay(long l) {
        this.delayable = new DelayableImpl(l, this.delayable.getLevelingDelay());
    }

    public long getLevelingDelay() {
        return this.delayable.getLevelingDelay();
    }

    void setLevelingDelay(long l) {
        this.delayable = new DelayableImpl(this.delayable.getDelay(), l);
    }

    public long calcTotalDelay() {
        return this.delayable.calcTotalDelay();
    }

    void setContour(Object object, Collection collection) {
        AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[collection.size()];
        collection.toArray(abstractContourBucketArray);
        this.setContour(object, abstractContourBucketArray);
    }

    void setContour(Object object, AbstractContourBucket[] abstractContourBucketArray) {
        if (object == HasTimeDistributedData.WORK) {
            this.workContour = PersonalContour.getInstance(abstractContourBucketArray);
        } else if (object == HasTimeDistributedData.COST) {
            this.costContour = PersonalContour.getInstance(abstractContourBucketArray);
        }
    }

    public int getRequestDemandType() {
        return this.requestDemandType;
    }

    void setRequestDemandType(int n) {
        this.requestDemandType = n;
    }

    void setWorkContour(AbstractContour abstractContour) {
        this.workContour = abstractContour;
    }

    void adjustRemainingDuration(long l) {
        if (l < 0L) {
            l = 0L;
        }
        if (this.getUnits() == 0.0) {
            l = 0L;
        }
        long l2 = this.getActualDuration();
        long l3 = l + l2;
        if (l2 > 0L && !this.workContour.isPersonal()) {
            this.workContour = PersonalContour.makePersonal(this.workContour, this.getDuration());
        }
        this.workContour = this.workContour.adjustDuration(l3, l2);
        l3 = this.workContour.calcTotalBucketDuration(l3);
        this.setDuration(l3);
    }

    void adjustRemainingUnits(double d) {
        this.workContour = this.workContour.adjustUnits(d / this.getUnits(), this.getActualDuration());
        this.setUnits(d);
    }

    void adjustRemainingWork(double d) {
        long l;
        AbstractContour abstractContour = this.workContour.contourAdjustWork(d, this.getActualDuration());
        if (this.workContour != abstractContour) {
            this.workContour = abstractContour;
            l = this.workContour.calcTotalBucketDuration(this.getDuration());
        } else {
            l = (long)((double)this.getActualDuration() + (double)this.getRemainingDuration() * d);
        }
        this.setDuration(l);
        this.setUnits(this.getUnits() / d);
    }

    long calcWorkingDuration() {
        return this.workContour.calcWorkingBucketDuration(this.getDuration());
    }

    void adjustWorkingDuration(long l) {
        this.adjustRemainingDuration(this.getDuration() + (l - this.calcWorkingDuration()));
    }

    TaskSchedule getTaskSchedule() {
        if (this.taskSchedule == null) {
            return this.getTask().getCurrentSchedule();
        }
        return this.taskSchedule;
    }

    TaskSchedule getTaskScheduleOfAssignment() {
        return this.taskSchedule;
    }

    void convertToBaselineAssignment(boolean bl) {
        try {
            this.baselineCalendar = bl ? CalendarService.getInstance().getDefaultInstance() : (WorkingCalendar)this.getEffectiveWorkCalendar().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    boolean isBaseline() {
        return this.baselineCalendar != null;
    }

    @Override
    public WorkCalendar getEffectiveWorkCalendar() {
        if (this.actualExceptionsCalendar != null) {
            return this.actualExceptionsCalendar;
        }
        if (this.baselineCalendar != null) {
            return this.baselineCalendar;
        }
        Resource resource = this.getResource();
        Task task = this.getTask();
        if (((NormalTask)task).isIgnoreResourceCalendar() || this.isInvalidIntersectionCalendar() || resource.getEffectiveWorkCalendar() == null) {
            return task.getEffectiveWorkCalendar();
        }
        if (task.getWorkCalendar() == null) {
            return resource.getEffectiveWorkCalendar();
        }
        if (this.intersectionCalendar == null) {
            try {
                this.intersectionCalendar = ((WorkingCalendar)task.getEffectiveWorkCalendar()).intersectWith((WorkingCalendar)resource.getEffectiveWorkCalendar());
            }
            catch (InvalidCalendarIntersectionException invalidCalendarIntersectionException) {
                this.intersectionCalendar = WorkingCalendar.INVALID_INTERSECTION_CALENDAR;
                Alert.error(Messages.getString("Message.invalidIntersection"));
                return task.getEffectiveWorkCalendar();
            }
        }
        return this.intersectionCalendar;
    }

    public boolean isInvalidIntersectionCalendar() {
        return this.intersectionCalendar == WorkingCalendar.INVALID_INTERSECTION_CALENDAR;
    }

    Task getTask() {
        return this.task;
    }

    @Override
    public long getStart() {
        long l;
        long l2 = this.calcTotalDelay();
        TaskSchedule taskSchedule = this.getTaskSchedule();
        long l3 = taskSchedule.getStart();
        if (this.percentComplete == 0.0 && (l = taskSchedule.getDependencyDate()) > l3 && !this.task.startsBeforeProject()) {
            l3 = l;
        }
        if (l2 > 0L) {
            l3 = this.getEffectiveWorkCalendar().add(l3, l2, false);
        }
        return l3;
    }

    @Override
    public void setStart(long l) {
        if (l > this.getTaskStart()) {
            long l2 = this.getEffectiveWorkCalendar().compare(l, this.getTaskStart(), false);
            this.setLevelingDelay(0L);
            this.setDelay(l2);
        }
    }

    long getSplitDuration() {
        long l = this.getDependencyStart();
        if (l == 0L || this.getDependencyStart() == this.getTaskStart()) {
            return 0L;
        }
        long l2 = Math.max(this.getTaskStart(), this.getStop());
        return Math.max(0L, this.getEffectiveWorkCalendar().compare(this.getDependencyStart(), l2, false));
    }

    long getFinish() {
        return this.getEnd();
    }

    Resource getResource() {
        return this.resource;
    }

    AbstractContourBucket[] getContour(Object object) {
        return (object == HasTimeDistributedData.COST ? this.costContour : this.workContour).getContourBuckets();
    }

    AbstractContour getCostContour() {
        return this.costContour;
    }

    int getCostRateIndex() {
        return this.costRateIndex;
    }

    void setCostRateIndex(int n) {
        this.costRateIndex = n;
    }

    Assignment getBaselineAssignment() {
        if (this.task == null) {
            return null;
        }
        return this.task.getBaselineAssignment(this.resource);
    }

    Assignment getBaselineAssignment(Object object, boolean bl) {
        if (this.task == null) {
            return null;
        }
        return this.task.getBaselineAssignment(this.resource, object, bl);
    }

    long effectiveBaselineStart() {
        Assignment assignment = this.getBaselineAssignment();
        if (assignment == null) {
            return this.getStart();
        }
        return assignment.getStart();
    }

    long effectiveBaselineStart(Object object) {
        Assignment assignment = this.getBaselineAssignment(object, false);
        if (assignment == null) {
            return this.getStart();
        }
        return assignment.getStart();
    }

    long effectiveBaselineFinish(Object object) {
        Assignment assignment = this.getBaselineAssignment(object, false);
        if (assignment == null) {
            return this.getFinish();
        }
        return assignment.getFinish();
    }

    long getResourceAvailability() {
        WorkCalendar workCalendar = this.resource.getEffectiveWorkCalendar();
        if (workCalendar == null) {
            workCalendar = this.task.getOwningProject().getEffectiveWorkCalendar();
        }
        return (long)this.resource.getMaximumUnits() * workCalendar.compare(this.getFinish(), this.getStart(), false);
    }

    void shift(long l, long l2, long l3) {
        PersonalContour personalContour = PersonalContour.makePersonal(this.workContour, this.getDuration());
        personalContour = personalContour.shift(l, l2, l3);
        this.workContour = personalContour;
        if (this.workContour.isPersonal()) {
            this.duration = this.workContour.calcTotalBucketDuration(this.duration);
        }
        this.checkForNegativeDuration();
    }

    private void checkForNegativeDuration() {
        if (this.duration < 0L) {
            if (this.getDelay() > 0L) {
                this.setDelay(0L);
            }
            this.duration = 0L;
        }
    }

    void extend(long l, long l2) {
        this.workContour = this.workContour.extend(l, l2);
        this.duration = this.workContour.isPersonal() ? this.workContour.calcTotalBucketDuration(this.duration) : (this.duration += l2);
        this.checkForNegativeDuration();
    }

    public void extendBefore(long l, long l2) {
        this.workContour = this.workContour.extendBefore(l, l2);
        this.duration = this.workContour.isPersonal() ? this.workContour.calcTotalBucketDuration(this.duration) : (this.duration -= l2);
        this.checkForNegativeDuration();
    }

    @Override
    public void split(Object object, long l, long l2) {
        System.out.println("split should not be called for AssignmentDetail");
    }

    public void removeEmptyBucketAtDuration(long l) {
        if (this.workContour.isPersonal()) {
            this.workContour = ((PersonalContour)this.workContour).removeEmptyBucketAtDuration(l);
        }
    }

    MutableInterval getRangeThatIntervalCanBeMoved(long l, long l2) {
        return this.workContour.getRangeThatIntervalCanBeMoved(l, l2);
    }

    @Override
    public void setWorkCalendar(WorkCalendar workCalendar) {
    }

    @Override
    public WorkCalendar getWorkCalendar() {
        return this.getEffectiveWorkCalendar();
    }

    @Override
    public long getDependencyStart() {
        return this.getTaskSchedule().getRemainingDependencyDate();
    }

    long getTaskStart() {
        return this.getTaskSchedule().getStart();
    }

    @Override
    public void setDuration(long l) {
        long l2 = this.getStop();
        if (Duration.millis(l) < 0L) {
            l = 0L;
        }
        this.duration = l;
        this.setStop(l2);
    }

    @Override
    public long getActualFinish() {
        if (this.getPercentComplete() < 1.0) {
            return 0L;
        }
        return this.getEnd();
    }

    @Override
    public void setActualFinish(long l) {
        this.setEnd(l);
        this.setPercentComplete(1.0);
    }

    @Override
    public long getEnd() {
        long l;
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        long l2 = workCalendar.add(this.getStart(), this.getDuration(), true);
        if (this.getPercentComplete() > 0.0 && this.getPercentComplete() < 1.0 && (l = this.getDependencyStart()) > this.getTaskStart()) {
            long l3 = workCalendar.compare(l, this.getTaskStart(), false);
            l2 = workCalendar.add(l2, l3, true);
        }
        return l2;
    }

    @Override
    public void setEnd(long l) {
        long l2;
        long l3;
        long l4 = this.getRemainingDuration();
        long l5 = this.getEnd();
        if (l5 == l) {
            return;
        }
        long l6 = this.getStop();
        if (l6 > l) {
            l = l6;
        }
        if ((l3 = l4 + (l2 = this.getEffectiveWorkCalendar().compare(l, l5, false))) < 0L) {
            l3 = 0L;
        }
        this.adjustRemainingDuration(l3);
        this.setStop(l6);
    }

    @Override
    public long getActualStart() {
        if (this.percentComplete == 0.0) {
            return 0L;
        }
        return this.getStart();
    }

    @Override
    public void setActualStart(long l) {
        this.setStart(l);
        if (this.percentComplete == 0.0) {
            this.setPercentComplete(1.0E-30);
        }
    }

    @Override
    public long getActualDuration() {
        return DateTime.closestDate((double)this.getDuration() * this.getPercentComplete());
    }

    @Override
    public void setActualDuration(long l) {
        if (this.getDuration() > 0L) {
            this.setPercentComplete((double)l / (double)this.getDuration());
        }
    }

    @Override
    public void clearDuration() {
        this.setDuration(0L);
    }

    @Override
    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval, boolean bl) {
        throw new RuntimeException("cannot call moveInterval for an AssignmentDetail");
    }

    @Override
    public void moveRemainingToDate(long l) {
        throw new RuntimeException("cannot call moveRemainingToDate for an AssignmentDetail");
    }

    @Override
    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        throw new RuntimeException("cannot call consumeIntervals for an AssignmentDetail");
    }

    @Override
    public long getElapsedDuration() {
        return Math.round((double)this.getEffectiveWorkCalendar().compare(this.getEnd(), this.getStart(), true) * CalendarOption.getInstance().getFractionOfDayThatIsWorking());
    }

    @Override
    public long getRemainingDuration() {
        return DateTime.closestDate((double)this.getDuration() * (1.0 - this.percentComplete));
    }

    @Override
    public void setRemainingDuration(long l) {
        this.setPercentComplete(1.0 - (double)l / (double)this.getDuration());
    }

    @Override
    public long getStop() {
        long l = 0L;
        if (this.percentComplete > 0.0 && this.percentComplete != 1.0E-30) {
            l = this.getEffectiveWorkCalendar().add(this.getStart(), this.getActualDuration(), true);
        }
        return l;
    }

    @Override
    public void setDependencyStart(long l) {
        throw new RuntimeException("cannot call setDependencyStart for an AssignmentDetail");
    }

    void removeFillerAfter(long l) {
        long l2 = this.getEffectiveWorkCalendar().compare(l, this.getStart(), false);
        this.workContour = this.workContour.removeFillerAfter(l2);
    }

    @Override
    public void setStop(long l) {
        if (l < this.getStart()) {
            return;
        }
        if (this.percentComplete == 1.0 && l >= this.getActualFinish()) {
            return;
        }
        if (l <= this.getStart()) {
            this.setPercentComplete(0.0);
        } else {
            long l2 = this.getEffectiveWorkCalendar().compare(l, this.getStart(), false);
            long l3 = this.getDuration();
            if (l3 != 0L) {
                this.setPercentComplete((double)l2 / (double)l3);
            }
        }
    }

    @Override
    public long getResume() {
        long l = 0L;
        if (this.percentComplete > 0.0) {
            l = this.getEffectiveWorkCalendar().add(this.getStart(), this.getActualDuration(), false);
        }
        l = Math.max(l, this.getDependencyStart());
        if (this.workContour.isPersonal()) {
            // empty if block
        }
        return l;
    }

    @Override
    public void setResume(long l) {
        long l2 = this.getResume();
        long l3 = this.getEffectiveWorkCalendar().compare(l, l2, false);
        if (l3 == 0L) {
            return;
        }
        if (l > l2) {
            // empty if block
        }
    }

    long extractDelay() {
        return this.workContour.extractDelay();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.workContourType = this.workContour.getType();
        this.costContourType = this.costContour.getType();
        objectOutputStream.defaultWriteObject();
        this.rate.serialize(objectOutputStream);
        objectOutputStream.writeLong(this.delayable.getDelay());
        objectOutputStream.writeLong(this.delayable.getLevelingDelay());
        if (this.workContourType == 8) {
            objectOutputStream.writeObject(this.workContour.getContourBuckets());
        }
        if (this.costContourType == 8) {
            objectOutputStream.writeObject(this.costContour.getContourBuckets());
        }
        if (this.version >= 1) {
            objectOutputStream.writeBoolean(this.taskSchedule == null);
            if (this.taskSchedule != null) {
                this.taskSchedule.serialize(objectOutputStream);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        objectInputStream.defaultReadObject();
        this.rate = Rate.deserialize(objectInputStream);
        this.delayable = new DelayableImpl(objectInputStream.readLong(), objectInputStream.readLong());
        this.workContour = this.workContourType == 8 ? PersonalContour.getInstance((AbstractContourBucket[])objectInputStream.readObject()) : StandardContour.getStandardContour(this.workContourType);
        this.costContour = this.costContourType == 8 ? PersonalContour.getInstance((AbstractContourBucket[])objectInputStream.readObject()) : StandardContour.getStandardContour(this.costContourType);
        if (this.version >= 1 && !(bl = objectInputStream.readBoolean())) {
            this.taskSchedule = TaskSchedule.deserialize(objectInputStream);
            this.taskSchedule.setTask(this.task);
        }
        this.version = DEFAULT_VERSION;
    }

    public Object clone() {
        AssignmentDetail assignmentDetail = new AssignmentDetail();
        assignmentDetail.rate = (Rate)this.rate.clone();
        assignmentDetail.percentComplete = this.percentComplete;
        assignmentDetail.duration = this.duration;
        assignmentDetail.workContour = (AbstractContour)this.workContour.clone();
        assignmentDetail.costContour = this.costContour;
        assignmentDetail.actualExceptionsCalendar = this.actualExceptionsCalendar;
        assignmentDetail.intersectionCalendar = this.intersectionCalendar;
        assignmentDetail.taskSchedule = this.taskSchedule;
        assignmentDetail.resource = this.resource;
        assignmentDetail.task = this.task;
        assignmentDetail.delayable = (Delayable)((DelayableImpl)this.delayable).clone();
        assignmentDetail.requestDemandType = this.requestDemandType;
        assignmentDetail.costRateIndex = this.costRateIndex;
        assignmentDetail.overtimeWork = this.overtimeWork;
        assignmentDetail.baselineCalendar = this.baselineCalendar;
        return assignmentDetail;
    }

    public long getOvertimeWork() {
        return this.overtimeWork;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    boolean hasDuration() {
        return this.duration != 0L;
    }

    public final boolean isTemporal() {
        return this.rate.getTimeUnit() != -2;
    }

    void setRateUnit(int n) {
        this.rate.setTimeUnit(n);
    }

    public final Rate getRate() {
        return this.rate;
    }

    public final void setRate(Rate rate) {
        this.rate = rate;
    }

    public void invalidateAssignmentCalendar() {
        if (this.intersectionCalendar != null) {
            this.intersectionCalendar = null;
        }
        if (this.actualExceptionsCalendar != null) {
            this.actualExceptionsCalendar.invalidate();
        }
    }

    @Override
    public Document invalidateCalendar() {
        return this.task.getOwningProject();
    }

    @Override
    public boolean isJustModified() {
        Task task = this.getTask();
        if (task == null) {
            return false;
        }
        return task.isJustModified();
    }

    public void addCalendarTime(long l, long l2) {
        if (this.actualExceptionsCalendar == null) {
            WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
            this.actualExceptionsCalendar = CalendarService.getInstance().getStandardBasedInstance();
            try {
                this.actualExceptionsCalendar.setBaseCalendar(workCalendar);
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        this.actualExceptionsCalendar.addCalendarTime(l, l2);
    }

    @Override
    public void setComplete(boolean bl) {
        ScheduleUtil.setComplete(this, bl);
    }

    @Override
    public boolean isComplete() {
        return this.getPercentComplete() == 1.0;
    }

    @Override
    public final long getEarliestStop() {
        return this.getStop();
    }

    @Override
    public final long getCompletedThrough() {
        return this.getStop();
    }

    @Override
    public void setCompletedThrough(long l) {
        this.setStop(l);
    }

    @Override
    public Object backupDetail() {
        return this.clone();
    }

    @Override
    public void restoreDetail(Object object, Object object2, boolean bl) {
    }
}

